/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.fasterxml.jackson.datatype.joda.ser;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.hive.druid.com.fasterxml.jackson.databind.SerializerProvider;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class JacksonJodaFormat {
    private static final String JODA_STYLE_CHARS = "SMLF-";
    protected static final Locale DEFAULT_LOCALE = Locale.getDefault();
    protected final DateTimeFormatter _formatter;
    protected final Boolean _useTimestamp;
    protected final TimeZone _jdkTimezone;
    protected final boolean _explicitTimezone;
    protected final Locale _locale;
    protected final boolean _explicitLocale;

    public JacksonJodaFormat(DateTimeFormatter defaultFormatter) {
        this._useTimestamp = null;
        this._jdkTimezone = defaultFormatter.getZone().toTimeZone();
        this._locale = DEFAULT_LOCALE;
        this._formatter = defaultFormatter;
        this._explicitTimezone = false;
        this._explicitLocale = false;
    }

    public JacksonJodaFormat(JacksonJodaFormat base, Boolean useTimestamp) {
        this._useTimestamp = useTimestamp;
        this._formatter = base._formatter;
        this._jdkTimezone = base._jdkTimezone;
        this._explicitTimezone = base._explicitTimezone;
        this._locale = base._locale;
        this._explicitLocale = base._explicitLocale;
    }

    public JacksonJodaFormat(JacksonJodaFormat base, DateTimeFormatter formatter) {
        this._useTimestamp = base._useTimestamp;
        this._formatter = formatter;
        this._jdkTimezone = base._jdkTimezone;
        this._explicitTimezone = base._explicitTimezone;
        this._locale = base._locale;
        this._explicitLocale = base._explicitLocale;
    }

    public JacksonJodaFormat(JacksonJodaFormat base, TimeZone jdkTimezone) {
        this._useTimestamp = base._useTimestamp;
        this._jdkTimezone = jdkTimezone;
        this._explicitTimezone = true;
        this._locale = base._locale;
        this._explicitLocale = base._explicitLocale;
        this._formatter = base._formatter.withZone(DateTimeZone.forTimeZone((TimeZone)jdkTimezone));
    }

    public JacksonJodaFormat(JacksonJodaFormat base, Locale locale) {
        this._useTimestamp = base._useTimestamp;
        this._jdkTimezone = base._jdkTimezone;
        this._explicitTimezone = base._explicitTimezone;
        this._locale = locale;
        this._explicitLocale = true;
        this._formatter = base._formatter.withLocale(locale);
    }

    protected JacksonJodaFormat withUseTimestamp(Boolean useTimestamp) {
        if (this._useTimestamp != null && this._useTimestamp.equals(useTimestamp)) {
            return this;
        }
        return new JacksonJodaFormat(this, useTimestamp);
    }

    protected JacksonJodaFormat withFormat(String format) {
        if (format == null || format.isEmpty()) {
            return this;
        }
        DateTimeFormatter formatter = JacksonJodaFormat._isStyle(format) ? DateTimeFormat.forStyle((String)format) : DateTimeFormat.forPattern((String)format);
        if (this._locale != null) {
            formatter = formatter.withLocale(this._locale);
        }
        formatter = formatter.withZone(this._formatter.getZone());
        return new JacksonJodaFormat(this, formatter);
    }

    protected JacksonJodaFormat withTimeZone(TimeZone tz) {
        if (tz == null || this._jdkTimezone != null && this._jdkTimezone.equals(tz)) {
            return this;
        }
        return new JacksonJodaFormat(this, tz);
    }

    protected JacksonJodaFormat withLocale(Locale locale) {
        if (locale == null || this._locale != null && this._locale.equals(locale)) {
            return this;
        }
        return new JacksonJodaFormat(this, locale);
    }

    public boolean useTimestamp(SerializerProvider provider) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        return provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public DateTimeFormatter createFormatter(SerializerProvider provider) {
        TimeZone tz;
        Locale loc;
        DateTimeFormatter formatter = this._formatter;
        if (!this._explicitLocale && (loc = provider.getLocale()) != null && !loc.equals(this._locale)) {
            formatter = formatter.withLocale(loc);
        }
        if (!this._explicitTimezone && (tz = provider.getTimeZone()) != null && !tz.equals(this._jdkTimezone)) {
            formatter = formatter.withZone(DateTimeZone.forTimeZone((TimeZone)tz));
        }
        return formatter;
    }

    protected static boolean _isStyle(String formatStr) {
        if (formatStr.length() != 2) {
            return false;
        }
        return JODA_STYLE_CHARS.indexOf(formatStr.charAt(0)) >= 0 && JODA_STYLE_CHARS.indexOf(formatStr.charAt(0)) >= 0;
    }
}

