/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.security;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidKerberosUtil {
    protected static final Logger log = LoggerFactory.getLogger(DruidKerberosUtil.class);
    private static final Base64 base64codec = new Base64(0);
    private static ReentrantLock kerberosLock = new ReentrantLock(true);

    public static String kerberosChallenge(String server) throws AuthenticationException {
        kerberosLock.lock();
        try {
            Oid mechOid = KerberosUtil.getOidInstance((String)"GSS_KRB5_MECH_OID");
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext gssContext = manager.createContext(serverName.canonicalize(mechOid), mechOid, null, 0);
            gssContext.requestMutualAuth(true);
            gssContext.requestCredDeleg(true);
            byte[] inToken = new byte[]{};
            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
            gssContext.dispose();
            log.debug("Got valid challenge for host {}", (Object)serverName);
            String string = new String(base64codec.encode(outToken), StandardCharsets.US_ASCII);
            return string;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | GSSException e) {
            throw new AuthenticationException((Throwable)e);
        }
        finally {
            kerberosLock.unlock();
        }
    }

    public static HttpCookie getAuthCookie(CookieStore cookieStore, URI uri) {
        if (cookieStore == null) {
            return null;
        }
        boolean isSSL = uri.getScheme().equals("https");
        List<HttpCookie> cookies = cookieStore.getCookies();
        for (int i = 0; i < cookies.size(); ++i) {
            HttpCookie c = cookies.get(i);
            if (c.getSecure() && !isSSL || !c.getName().equals("hadoop.auth")) continue;
            return c;
        }
        return null;
    }

    public static void removeAuthCookie(CookieStore cookieStore, URI uri) {
        HttpCookie authCookie = DruidKerberosUtil.getAuthCookie(cookieStore, uri);
        if (authCookie != null) {
            cookieStore.remove(uri, authCookie);
        }
    }

    public static boolean needToSendCredentials(CookieStore cookieStore, URI uri) {
        return DruidKerberosUtil.getAuthCookie(cookieStore, uri) == null;
    }
}

