/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public class HiveDruidSplit
extends FileSplit
implements InputSplit {
    private String druidQuery;
    private String[] hosts;

    public HiveDruidSplit() {
        super((Path)null, 0L, 0L, (String[])null);
    }

    public HiveDruidSplit(String druidQuery, Path dummyPath, String[] hosts) {
        super(dummyPath, 0L, 0L, hosts);
        this.druidQuery = druidQuery;
        this.hosts = hosts;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.druidQuery);
        out.writeInt(this.hosts.length);
        for (String host : this.hosts) {
            out.writeUTF(host);
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.druidQuery = in.readUTF();
        int length = in.readInt();
        String[] listHosts = new String[length];
        for (int i = 0; i < length; ++i) {
            listHosts[i] = in.readUTF();
        }
        this.hosts = listHosts;
    }

    public String getDruidQuery() {
        return this.druidQuery;
    }

    public String[] getLocations() throws IOException {
        return this.hosts;
    }

    public String toString() {
        return "HiveDruidSplit{" + this.druidQuery + ", " + (this.hosts == null ? "empty hosts" : Arrays.toString(this.hosts)) + "}";
    }
}

