/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.DruidRecordWriter;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionSchema;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.CustomVersioningPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidOutputFormat<K, V>
implements HiveOutputFormat<K, DruidWritable> {
    protected static final Logger LOG = LoggerFactory.getLogger(DruidOutputFormat.class);

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        int targetNumShardsPerGranularity = Integer.parseUnsignedInt(tableProperties.getProperty("druid.segment.targetShardsPerGranularity", "0"));
        int maxPartitionSize = targetNumShardsPerGranularity > 0 ? -1 : HiveConf.getIntVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_MAX_PARTITION_SIZE);
        String dataSource = tableProperties.getProperty("druid.datasource") == null ? jc.get("druid.datasource") : tableProperties.getProperty("druid.datasource");
        String segmentDirectory = jc.get("druid.storage.storageDirectory.intermediate");
        GranularitySpec granularitySpec = DruidStorageHandlerUtils.getGranularitySpec((Configuration)jc, tableProperties);
        String columnNameProperty = tableProperties.getProperty("columns");
        String columnTypeProperty = tableProperties.getProperty("columns.types");
        if (StringUtils.isEmpty((String)columnNameProperty) || StringUtils.isEmpty((String)columnTypeProperty)) {
            throw new IllegalStateException(String.format("List of columns names [%s] or columns type [%s] is/are not present", columnNameProperty, columnTypeProperty));
        }
        ArrayList<String> columnNames = Lists.newArrayList(columnNameProperty.split(","));
        if (!columnNames.contains("__time")) {
            throw new IllegalStateException("Timestamp column (' __time') not specified in create table; list of columns is : " + tableProperties.getProperty("columns"));
        }
        ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        Pair<List<DimensionSchema>, AggregatorFactory[]> dimensionsAndAggregates = DruidStorageHandlerUtils.getDimensionsAndAggregates((Configuration)jc, columnNames, columnTypes);
        MapInputRowParser inputRowParser = new MapInputRowParser(new TimeAndDimsParseSpec(new TimestampSpec("__time", "auto", null), new DimensionsSpec((List)dimensionsAndAggregates.lhs, Lists.newArrayList("__time_granularity", "__druid_extra_partition_key"), null)));
        Map inputParser = DruidStorageHandlerUtils.JSON_MAPPER.convertValue((Object)inputRowParser, Map.class);
        DataSchema dataSchema = new DataSchema(Preconditions.checkNotNull(dataSource, "Data source name is null"), inputParser, (AggregatorFactory[])dimensionsAndAggregates.rhs, granularitySpec, null, DruidStorageHandlerUtils.JSON_MAPPER);
        String workingPath = jc.get("druid.job.workingDirectory");
        String version = jc.get("druid.segment.version");
        String basePersistDirectory = HiveConf.getVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BASE_PERSIST_DIRECTORY);
        if (Strings.isNullOrEmpty(basePersistDirectory)) {
            basePersistDirectory = System.getProperty("java.io.tmpdir");
        }
        Integer maxRowInMemory = HiveConf.getIntVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_MAX_ROW_IN_MEMORY);
        IndexSpec indexSpec = DruidStorageHandlerUtils.getIndexSpec((Configuration)jc);
        RealtimeTuningConfig realtimeTuningConfig = new RealtimeTuningConfig(maxRowInMemory, null, null, new File(basePersistDirectory, dataSource), new CustomVersioningPolicy(version), null, null, null, indexSpec, true, 0, 0, true, null, 0L, null);
        LOG.debug(String.format("running with Data schema [%s] ", dataSchema));
        return new DruidRecordWriter(dataSchema, realtimeTuningConfig, DruidStorageHandlerUtils.createSegmentPusherForDirectory(segmentDirectory, (Configuration)jc), maxPartitionSize, new Path(workingPath, "segmentsDescriptorDir"), finalOutPath.getFileSystem((Configuration)jc));
    }

    public RecordWriter<K, DruidWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("please implement me !");
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
    }
}

