/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelProgressiveFuture;
import org.apache.hive.druid.io.netty.handler.codec.http.LastHttpContent;
import org.apache.hive.druid.io.netty.handler.stream.ChunkedStream;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.WriteProgressListener;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyInputStreamBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyInputStreamBody.class);
    private final InputStream inputStream;
    private final long contentLength;

    public NettyInputStreamBody(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public NettyInputStreamBody(InputStream inputStream, long contentLength) {
        this.inputStream = inputStream;
        this.contentLength = contentLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        final InputStream is = this.inputStream;
        if (future.isStreamConsumed()) {
            if (!is.markSupported()) {
                LOGGER.warn("Stream has already been consumed and cannot be reset");
                return;
            }
            is.reset();
        } else {
            future.setStreamConsumed(true);
        }
        channel.write(new ChunkedStream(is), channel.newProgressivePromise()).addListener(new WriteProgressListener(future, false, this.getContentLength()){

            @Override
            public void operationComplete(ChannelProgressiveFuture cf) {
                MiscUtils.closeSilently(is);
                super.operationComplete(cf);
            }
        });
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, channel.voidPromise());
    }
}

