/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch;

import java.util.List;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.AbstractElasticsearchTable;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.ElasticsearchRules;
import org.apache.hive.druid.org.apache.calcite.adapter.elasticsearch.ElasticsearchToEnumerableConverterRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptTable;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.TableScan;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;

public class ElasticsearchTableScan
extends TableScan
implements ElasticsearchRel {
    private final AbstractElasticsearchTable elasticsearchTable;
    private final RelDataType projectRowType;

    protected ElasticsearchTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, AbstractElasticsearchTable elasticsearchTable, RelDataType projectRowType) {
        super(cluster, traitSet, table);
        this.elasticsearchTable = Preconditions.checkNotNull(elasticsearchTable);
        this.projectRowType = projectRowType;
        assert (this.getConvention() == ElasticsearchRel.CONVENTION);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        float f = this.projectRowType == null ? 1.0f : (float)this.projectRowType.getFieldCount() / 100.0f;
        return super.computeSelfCost(planner, mq).multiplyBy(0.1 * (double)f);
    }

    @Override
    public void register(RelOptPlanner planner) {
        planner.addRule(ElasticsearchToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : ElasticsearchRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(ElasticsearchRel.Implementor implementor) {
        implementor.elasticsearchTable = this.elasticsearchTable;
        implementor.table = this.table;
    }
}

