/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.stomp;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.ByteBufUtil;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.hive.druid.io.netty.handler.codec.stomp.LastStompContentSubframe;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompCommand;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompContentSubframe;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompFrame;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompHeaders;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompHeadersSubframe;
import org.apache.hive.druid.io.netty.handler.codec.stomp.StompSubframe;
import org.apache.hive.druid.io.netty.util.concurrent.FastThreadLocal;
import org.apache.hive.druid.io.netty.util.internal.AppendableCharSequence;

public class StompSubframeEncoder
extends MessageToMessageEncoder<StompSubframe> {
    private static final int ESCAPE_HEADER_KEY_CACHE_LIMIT = 32;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final FastThreadLocal<LinkedHashMap<CharSequence, CharSequence>> ESCAPE_HEADER_KEY_CACHE = new FastThreadLocal<LinkedHashMap<CharSequence, CharSequence>>(){

        @Override
        protected LinkedHashMap<CharSequence, CharSequence> initialValue() throws Exception {
            LinkedHashMap<CharSequence, CharSequence> cache = new LinkedHashMap<CharSequence, CharSequence>(32, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 32;
                }
            };
            cache.put((CharSequence)StompHeaders.ACCEPT_VERSION, (CharSequence)StompHeaders.ACCEPT_VERSION);
            cache.put((CharSequence)StompHeaders.HOST, (CharSequence)StompHeaders.HOST);
            cache.put((CharSequence)StompHeaders.LOGIN, (CharSequence)StompHeaders.LOGIN);
            cache.put((CharSequence)StompHeaders.PASSCODE, (CharSequence)StompHeaders.PASSCODE);
            cache.put((CharSequence)StompHeaders.HEART_BEAT, (CharSequence)StompHeaders.HEART_BEAT);
            cache.put((CharSequence)StompHeaders.VERSION, (CharSequence)StompHeaders.VERSION);
            cache.put((CharSequence)StompHeaders.SESSION, (CharSequence)StompHeaders.SESSION);
            cache.put((CharSequence)StompHeaders.SERVER, (CharSequence)StompHeaders.SERVER);
            cache.put((CharSequence)StompHeaders.DESTINATION, (CharSequence)StompHeaders.DESTINATION);
            cache.put((CharSequence)StompHeaders.ID, (CharSequence)StompHeaders.ID);
            cache.put((CharSequence)StompHeaders.ACK, (CharSequence)StompHeaders.ACK);
            cache.put((CharSequence)StompHeaders.TRANSACTION, (CharSequence)StompHeaders.TRANSACTION);
            cache.put((CharSequence)StompHeaders.RECEIPT, (CharSequence)StompHeaders.RECEIPT);
            cache.put((CharSequence)StompHeaders.MESSAGE_ID, (CharSequence)StompHeaders.MESSAGE_ID);
            cache.put((CharSequence)StompHeaders.SUBSCRIPTION, (CharSequence)StompHeaders.SUBSCRIPTION);
            cache.put((CharSequence)StompHeaders.RECEIPT_ID, (CharSequence)StompHeaders.RECEIPT_ID);
            cache.put((CharSequence)StompHeaders.MESSAGE, (CharSequence)StompHeaders.MESSAGE);
            cache.put((CharSequence)StompHeaders.CONTENT_LENGTH, (CharSequence)StompHeaders.CONTENT_LENGTH);
            cache.put((CharSequence)StompHeaders.CONTENT_TYPE, (CharSequence)StompHeaders.CONTENT_TYPE);
            return cache;
        }
    };

    @Override
    protected void encode(ChannelHandlerContext ctx, StompSubframe msg, List<Object> out) throws Exception {
        if (msg instanceof StompFrame) {
            StompFrame stompFrame = (StompFrame)msg;
            ByteBuf buf = this.encodeFullFrame(stompFrame, ctx);
            out.add(this.convertFullFrame(stompFrame, buf));
        } else if (msg instanceof StompHeadersSubframe) {
            StompHeadersSubframe stompHeadersSubframe = (StompHeadersSubframe)msg;
            ByteBuf buf = ctx.alloc().buffer(this.headersSubFrameSize(stompHeadersSubframe));
            StompSubframeEncoder.encodeHeaders(stompHeadersSubframe, buf);
            out.add(this.convertHeadersSubFrame(stompHeadersSubframe, buf));
        } else if (msg instanceof StompContentSubframe) {
            StompContentSubframe stompContentSubframe = (StompContentSubframe)msg;
            ByteBuf buf = StompSubframeEncoder.encodeContent(stompContentSubframe, ctx);
            out.add(this.convertContentSubFrame(stompContentSubframe, buf));
        }
    }

    protected Object convertFullFrame(StompFrame original, ByteBuf encoded) {
        return encoded;
    }

    protected Object convertHeadersSubFrame(StompHeadersSubframe original, ByteBuf encoded) {
        return encoded;
    }

    protected Object convertContentSubFrame(StompContentSubframe original, ByteBuf encoded) {
        return encoded;
    }

    protected int headersSubFrameSize(StompHeadersSubframe headersSubframe) {
        int estimatedSize = headersSubframe.headers().size() * 34 + 48;
        if (estimatedSize < 128) {
            return 128;
        }
        return Math.max(estimatedSize, 256);
    }

    private ByteBuf encodeFullFrame(StompFrame frame, ChannelHandlerContext ctx) {
        int contentReadableBytes = frame.content().readableBytes();
        ByteBuf buf = ctx.alloc().buffer(this.headersSubFrameSize(frame) + contentReadableBytes);
        StompSubframeEncoder.encodeHeaders(frame, buf);
        if (contentReadableBytes > 0) {
            buf.writeBytes(frame.content());
        }
        return buf.writeByte(0);
    }

    private static void encodeHeaders(StompHeadersSubframe frame, ByteBuf buf) {
        StompCommand command = frame.command();
        ByteBufUtil.writeUtf8(buf, (CharSequence)command.toString());
        buf.writeByte(10);
        boolean shouldEscape = StompSubframeEncoder.shouldEscape(command);
        LinkedHashMap<CharSequence, CharSequence> cache = ESCAPE_HEADER_KEY_CACHE.get();
        Iterator iterator = frame.headers().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CharSequence headerKey = (CharSequence)entry.getKey();
            if (shouldEscape) {
                CharSequence cachedHeaderKey = cache.get(headerKey);
                if (cachedHeaderKey == null) {
                    cachedHeaderKey = StompSubframeEncoder.escape(headerKey);
                    cache.put(headerKey, cachedHeaderKey);
                }
                headerKey = cachedHeaderKey;
            }
            ByteBufUtil.writeUtf8(buf, headerKey);
            buf.writeByte(58);
            CharSequence headerValue = shouldEscape ? StompSubframeEncoder.escape((CharSequence)entry.getValue()) : (CharSequence)entry.getValue();
            ByteBufUtil.writeUtf8(buf, headerValue);
            buf.writeByte(10);
        }
        buf.writeByte(10);
    }

    private static ByteBuf encodeContent(StompContentSubframe content, ChannelHandlerContext ctx) {
        if (content instanceof LastStompContentSubframe) {
            ByteBuf buf = ctx.alloc().buffer(content.content().readableBytes() + 1);
            buf.writeBytes(content.content());
            buf.writeByte(0);
            return buf;
        }
        return content.content().retain();
    }

    private static boolean shouldEscape(StompCommand command) {
        return command != StompCommand.CONNECT && command != StompCommand.CONNECTED;
    }

    private static CharSequence escape(CharSequence input) {
        CharSequence builder = null;
        for (int i = 0; i < input.length(); ++i) {
            char chr = input.charAt(i);
            if (chr == '\\') {
                builder = StompSubframeEncoder.escapeBuilder((AppendableCharSequence)builder, input, i);
                ((AppendableCharSequence)builder).append("\\\\");
                continue;
            }
            if (chr == ':') {
                builder = StompSubframeEncoder.escapeBuilder((AppendableCharSequence)builder, input, i);
                ((AppendableCharSequence)builder).append("\\c");
                continue;
            }
            if (chr == '\n') {
                builder = StompSubframeEncoder.escapeBuilder((AppendableCharSequence)builder, input, i);
                ((AppendableCharSequence)builder).append("\\n");
                continue;
            }
            if (chr == '\r') {
                builder = StompSubframeEncoder.escapeBuilder((AppendableCharSequence)builder, input, i);
                ((AppendableCharSequence)builder).append("\\r");
                continue;
            }
            if (builder == null) continue;
            ((AppendableCharSequence)builder).append(chr);
        }
        return builder != null ? builder : input;
    }

    private static AppendableCharSequence escapeBuilder(AppendableCharSequence builder, CharSequence input, int offset) {
        if (builder != null) {
            return builder;
        }
        return new AppendableCharSequence(input.length() + 8).append(input, 0, offset);
    }
}

