/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.Parser;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.virtual.ExpressionSelectors;

public class SingleStringInputCachingExpressionColumnValueSelector
implements ColumnValueSelector<ExprEval> {
    private static final int CACHE_SIZE = 1000;
    private final DimensionSelector selector;
    private final Expr expression;
    private final Expr.ObjectBinding bindings;
    private final ExprEval[] arrayEvalCache;
    private final LruEvalCache lruEvalCache;

    public SingleStringInputCachingExpressionColumnValueSelector(DimensionSelector selector, Expr expression) {
        if (Parser.findRequiredBindings(expression).size() != 1) {
            throw new ISE("WTF?! Expected expression with just one binding", new Object[0]);
        }
        this.selector = Preconditions.checkNotNull(selector, "selector");
        this.expression = Preconditions.checkNotNull(expression, "expression");
        Supplier<Object> inputSupplier = ExpressionSelectors.supplierFromDimensionSelector(selector);
        this.bindings = name -> inputSupplier.get();
        if (selector.getValueCardinality() == -1) {
            throw new ISE("Selector must have a dictionary", new Object[0]);
        }
        if (selector.getValueCardinality() <= 1000) {
            this.arrayEvalCache = new ExprEval[selector.getValueCardinality()];
            this.lruEvalCache = null;
        } else {
            this.arrayEvalCache = null;
            this.lruEvalCache = new LruEvalCache(expression, this.bindings);
        }
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("expression", this.expression);
    }

    @Override
    public double getDouble() {
        return this.eval().asDouble();
    }

    @Override
    public float getFloat() {
        return (float)this.eval().asDouble();
    }

    @Override
    public long getLong() {
        return this.eval().asLong();
    }

    @Override
    @Nullable
    public ExprEval getObject() {
        return this.eval();
    }

    @Override
    public Class<ExprEval> classOfObject() {
        return ExprEval.class;
    }

    private ExprEval eval() {
        IndexedInts row = this.selector.getRow();
        if (row.size() == 1) {
            int id = row.get(0);
            if (this.arrayEvalCache != null) {
                if (this.arrayEvalCache[id] == null) {
                    this.arrayEvalCache[id] = this.expression.eval(this.bindings);
                }
                return this.arrayEvalCache[id];
            }
            assert (this.lruEvalCache != null);
            return this.lruEvalCache.compute(id);
        }
        return this.expression.eval(this.bindings);
    }

    public static class LruEvalCache {
        private final Expr expression;
        private final Expr.ObjectBinding bindings;
        private final Int2ObjectLinkedOpenHashMap<ExprEval> m = new Int2ObjectLinkedOpenHashMap(1000);

        public LruEvalCache(Expr expression, Expr.ObjectBinding bindings) {
            this.expression = expression;
            this.bindings = bindings;
        }

        public ExprEval compute(int id) {
            ExprEval value = this.m.getAndMoveToFirst(id);
            if (value == null) {
                value = this.expression.eval(this.bindings);
                this.m.putAndMoveToFirst(id, value);
                if (this.m.size() > 1000) {
                    this.m.removeLast();
                }
            }
            return value;
        }
    }
}

