/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.transform;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.segment.transform.TransformSpec;
import org.apache.hive.druid.io.druid.segment.transform.Transformer;

public class TransformingInputRowParser<T>
implements InputRowParser<T> {
    private final InputRowParser<T> parser;
    private final TransformSpec transformSpec;
    private final Transformer transformer;

    public TransformingInputRowParser(InputRowParser<T> parser, TransformSpec transformSpec) {
        this.parser = parser;
        this.transformSpec = transformSpec;
        this.transformer = transformSpec.toTransformer();
    }

    public InputRowParser<T> getParser() {
        return this.parser;
    }

    @Override
    public List<InputRow> parseBatch(T row) {
        return this.parser.parseBatch(row).stream().map(this.transformer::transform).collect(Collectors.toList());
    }

    @Override
    public ParseSpec getParseSpec() {
        return this.parser.getParseSpec();
    }

    @Override
    public InputRowParser<T> withParseSpec(ParseSpec parseSpec) {
        return new TransformingInputRowParser<T>(this.parser.withParseSpec(parseSpec), this.transformSpec);
    }

    public TransformSpec getTransformSpec() {
        return this.transformSpec;
    }
}

