/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.segment.data.ColumnarFloats;

public class EntireLayoutColumnarFloatsSupplier
implements Supplier<ColumnarFloats> {
    private final int totalSize;
    private FloatBuffer buffer;

    public EntireLayoutColumnarFloatsSupplier(int totalSize, ByteBuffer fromBuffer, ByteOrder order) {
        this.totalSize = totalSize;
        this.buffer = fromBuffer.asReadOnlyBuffer().order(order).asFloatBuffer();
    }

    @Override
    public ColumnarFloats get() {
        return new EntireLayoutColumnarFloats();
    }

    private class EntireLayoutColumnarFloats
    implements ColumnarFloats {
        private EntireLayoutColumnarFloats() {
        }

        @Override
        public int size() {
            return EntireLayoutColumnarFloatsSupplier.this.totalSize;
        }

        @Override
        public float get(int index) {
            return EntireLayoutColumnarFloatsSupplier.this.buffer.get(EntireLayoutColumnarFloatsSupplier.this.buffer.position() + index);
        }

        @Override
        public void fill(int index, float[] toFill) {
            if (EntireLayoutColumnarFloatsSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(StringUtils.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, EntireLayoutColumnarFloatsSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        public String toString() {
            return "EntireCompressedColumnarFloats_Anonymous{, totalSize=" + EntireLayoutColumnarFloatsSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
        }
    }
}

