/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.segment.data.ColumnarLongs;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.LongsLongEncodingReader;

public class BlockLayoutColumnarLongsSupplier
implements Supplier<ColumnarLongs> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseLongBuffers;
    private final int totalSize;
    private final int sizePer;
    private final CompressionFactory.LongEncodingReader baseReader;

    public BlockLayoutColumnarLongsSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressionFactory.LongEncodingReader reader, CompressionStrategy strategy) {
        this.baseLongBuffers = GenericIndexed.read(fromBuffer, new DecompressingByteBufferObjectStrategy(order, strategy));
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseReader = reader;
    }

    @Override
    public ColumnarLongs get() {
        boolean powerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = powerOf2 = this.sizePer == 1 << div;
        if (powerOf2) {
            if (this.baseReader instanceof LongsLongEncodingReader) {
                return new BlockLayoutColumnarLongs(){

                    @Override
                    public long get(int index) {
                        int bufferNum = index >> div;
                        if (bufferNum != this.currIndex) {
                            this.loadBuffer(bufferNum);
                        }
                        int bufferIndex = index & rem;
                        return this.longBuffer.get(this.longBuffer.position() + bufferIndex);
                    }

                    @Override
                    protected void loadBuffer(int bufferNum) {
                        CloseQuietly.close(this.holder);
                        this.holder = (ResourceHolder)this.singleThreadedLongBuffers.get(bufferNum);
                        this.buffer = (ByteBuffer)this.holder.get();
                        this.longBuffer = this.buffer.asLongBuffer();
                        this.currIndex = bufferNum;
                    }
                };
            }
            return new BlockLayoutColumnarLongs(){

                @Override
                public long get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.reader.read(bufferIndex);
                }
            };
        }
        return new BlockLayoutColumnarLongs();
    }

    private class BlockLayoutColumnarLongs
    implements ColumnarLongs {
        final CompressionFactory.LongEncodingReader reader;
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedLongBuffers;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        LongBuffer longBuffer;

        private BlockLayoutColumnarLongs() {
            this.reader = BlockLayoutColumnarLongsSupplier.this.baseReader.duplicate();
            this.singleThreadedLongBuffers = BlockLayoutColumnarLongsSupplier.this.baseLongBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return BlockLayoutColumnarLongsSupplier.this.totalSize;
        }

        @Override
        public long get(int index) {
            int bufferNum = index / BlockLayoutColumnarLongsSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutColumnarLongsSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.reader.read(bufferIndex);
        }

        @Override
        public void fill(int index, long[] toFill) {
            if (BlockLayoutColumnarLongsSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(StringUtils.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, BlockLayoutColumnarLongsSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedLongBuffers.get(bufferNum);
            this.buffer = this.holder.get();
            this.currIndex = bufferNum;
            this.reader.setBuffer(this.buffer);
        }

        public String toString() {
            return "BlockCompressedColumnarLongs_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + BlockLayoutColumnarLongsSupplier.this.sizePer + ", numChunks=" + this.singleThreadedLongBuffers.size() + ", totalSize=" + BlockLayoutColumnarLongsSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }
    }
}

