/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.segment.data.ColumnarFloats;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;

public class BlockLayoutColumnarFloatsSupplier
implements Supplier<ColumnarFloats> {
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseFloatBuffers;
    private final int totalSize;
    private final int sizePer;

    public BlockLayoutColumnarFloatsSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressionStrategy strategy) {
        this.baseFloatBuffers = GenericIndexed.read(fromBuffer, new DecompressingByteBufferObjectStrategy(order, strategy));
        this.totalSize = totalSize;
        this.sizePer = sizePer;
    }

    @Override
    public ColumnarFloats get() {
        boolean powerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = powerOf2 = this.sizePer == 1 << div;
        if (powerOf2) {
            return new BlockLayoutColumnarFloats(){

                @Override
                public float get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.floatBuffer.get(this.floatBuffer.position() + bufferIndex);
                }
            };
        }
        return new BlockLayoutColumnarFloats();
    }

    private class BlockLayoutColumnarFloats
    implements ColumnarFloats {
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedFloatBuffers;
        int currIndex;
        ResourceHolder<ByteBuffer> holder;
        ByteBuffer buffer;
        FloatBuffer floatBuffer;

        private BlockLayoutColumnarFloats() {
            this.singleThreadedFloatBuffers = BlockLayoutColumnarFloatsSupplier.this.baseFloatBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return BlockLayoutColumnarFloatsSupplier.this.totalSize;
        }

        @Override
        public float get(int index) {
            int bufferNum = index / BlockLayoutColumnarFloatsSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutColumnarFloatsSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.floatBuffer.get(this.floatBuffer.position() + bufferIndex);
        }

        @Override
        public void fill(int index, float[] toFill) {
            if (BlockLayoutColumnarFloatsSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(StringUtils.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, BlockLayoutColumnarFloatsSupplier.this.totalSize));
            }
            for (int i = 0; i < toFill.length; ++i) {
                toFill[i] = this.get(index + i);
            }
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedFloatBuffers.get(bufferNum);
            this.buffer = this.holder.get();
            this.floatBuffer = this.buffer.asFloatBuffer();
            this.currIndex = bufferNum;
        }

        public String toString() {
            return "BlockCompressedColumnarFloats_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + BlockLayoutColumnarFloatsSupplier.this.sizePer + ", numChunks=" + this.singleThreadedFloatBuffers.size() + ", totalSize=" + BlockLayoutColumnarFloatsSupplier.this.totalSize + '}';
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.holder.close();
            }
        }
    }
}

