/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;

public class Metadata {
    @JsonProperty
    private final Map<String, Object> container = new ConcurrentHashMap<String, Object>();
    @JsonProperty
    private AggregatorFactory[] aggregators;
    @JsonProperty
    private TimestampSpec timestampSpec;
    @JsonProperty
    private Granularity queryGranularity;
    @JsonProperty
    private Boolean rollup;

    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    public Metadata setAggregators(AggregatorFactory[] aggregators) {
        this.aggregators = aggregators;
        return this;
    }

    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    public Metadata setTimestampSpec(TimestampSpec timestampSpec) {
        this.timestampSpec = timestampSpec;
        return this;
    }

    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    public Metadata setQueryGranularity(Granularity queryGranularity) {
        this.queryGranularity = queryGranularity;
        return this;
    }

    public Boolean isRollup() {
        return this.rollup;
    }

    public Metadata setRollup(Boolean rollup) {
        this.rollup = rollup;
        return this;
    }

    public Metadata putAll(Map<String, Object> other) {
        if (other != null) {
            this.container.putAll(other);
        }
        return this;
    }

    public Object get(String key) {
        return this.container.get(key);
    }

    public Metadata put(String key, Object value) {
        if (value != null) {
            this.container.put(key, value);
        }
        return this;
    }

    public static Metadata merge(List<Metadata> toBeMerged, AggregatorFactory[] overrideMergedAggregators) {
        if (toBeMerged == null || toBeMerged.size() == 0) {
            return null;
        }
        boolean foundSomeMetadata = false;
        HashMap<String, Object> mergedContainer = new HashMap<String, Object>();
        ArrayList<AggregatorFactory[]> aggregatorsToMerge = overrideMergedAggregators == null ? new ArrayList<AggregatorFactory[]>() : null;
        ArrayList<TimestampSpec> timestampSpecsToMerge = new ArrayList<TimestampSpec>();
        ArrayList<Granularity> gransToMerge = new ArrayList<Granularity>();
        ArrayList<Boolean> rollupToMerge = new ArrayList<Boolean>();
        for (Metadata metadata : toBeMerged) {
            if (metadata != null) {
                foundSomeMetadata = true;
                if (aggregatorsToMerge != null) {
                    aggregatorsToMerge.add(metadata.getAggregators());
                }
                if (timestampSpecsToMerge != null && metadata.getTimestampSpec() != null) {
                    timestampSpecsToMerge.add(metadata.getTimestampSpec());
                }
                if (gransToMerge != null) {
                    gransToMerge.add(metadata.getQueryGranularity());
                }
                if (rollupToMerge != null) {
                    rollupToMerge.add(metadata.isRollup());
                }
                mergedContainer.putAll(metadata.container);
                continue;
            }
            aggregatorsToMerge = null;
            timestampSpecsToMerge = null;
            gransToMerge = null;
            rollupToMerge = null;
        }
        if (!foundSomeMetadata) {
            return null;
        }
        Metadata result = new Metadata();
        if (aggregatorsToMerge != null) {
            result.setAggregators(AggregatorFactory.mergeAggregators(aggregatorsToMerge));
        } else {
            result.setAggregators(overrideMergedAggregators);
        }
        if (timestampSpecsToMerge != null) {
            result.setTimestampSpec(TimestampSpec.mergeTimestampSpec(timestampSpecsToMerge));
        }
        if (gransToMerge != null) {
            result.setQueryGranularity(Granularity.mergeGranularities(gransToMerge));
        }
        Boolean rollup = null;
        if (rollupToMerge != null && !rollupToMerge.isEmpty()) {
            rollup = (Boolean)rollupToMerge.get(0);
            for (Boolean r : rollupToMerge) {
                if (r == null) {
                    rollup = null;
                    break;
                }
                if (!r.equals(rollup)) {
                    rollup = null;
                    break;
                }
                rollup = r;
            }
        }
        result.setRollup(rollup);
        result.container.putAll(mergedContainer);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        if (!this.container.equals(metadata.container)) {
            return false;
        }
        if (!Arrays.equals(this.aggregators, metadata.aggregators)) {
            return false;
        }
        if (this.timestampSpec != null ? !this.timestampSpec.equals(metadata.timestampSpec) : metadata.timestampSpec != null) {
            return false;
        }
        if (this.rollup != null ? !this.rollup.equals(metadata.rollup) : metadata.rollup != null) {
            return false;
        }
        return this.queryGranularity != null ? this.queryGranularity.equals(metadata.queryGranularity) : metadata.queryGranularity == null;
    }

    public int hashCode() {
        int result = this.container.hashCode();
        result = 31 * result + Arrays.hashCode(this.aggregators);
        result = 31 * result + (this.timestampSpec != null ? this.timestampSpec.hashCode() : 0);
        result = 31 * result + (this.queryGranularity != null ? this.queryGranularity.hashCode() : 0);
        result = 31 * result + (this.rollup != null ? this.rollup.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Metadata{container=" + this.container + ", aggregators=" + Arrays.toString(this.aggregators) + ", timestampSpec=" + this.timestampSpec + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + '}';
    }
}

