/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.post;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.cache.CacheKeyBuilder;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptPostAggregator
implements PostAggregator {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return ((Double)o).compareTo((Double)o1);
        }
    };
    private final String name;
    private final List<String> fieldNames;
    private final String function;
    private final JavaScriptConfig config;
    private Function fn;

    private static Function compile(String function) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fn = context.compileFunction((Scriptable)scope, function, "fn", 1, null);
        Context.exit();
        return new Function(){

            @Override
            public double apply(Object[] args) {
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                }
                return Context.toNumber((Object)fn.call(cx, (Scriptable)scope, (Scriptable)scope, args));
            }
        };
    }

    @JsonCreator
    public JavaScriptPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="function") String function, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull(name, "Must have a valid, non-null post-aggregator name");
        Preconditions.checkNotNull(fieldNames, "Must have a valid, non-null fieldNames");
        Preconditions.checkNotNull(function, "Must have a valid, non-null function");
        this.name = name;
        this.fieldNames = fieldNames;
        this.function = function;
        this.config = config;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet(this.fieldNames);
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        this.checkAndCompileScript();
        Object[] args = new Object[this.fieldNames.size()];
        int i = 0;
        for (String field : this.fieldNames) {
            args[i++] = combinedAggregators.get(field);
        }
        return this.fn.apply(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCompileScript() {
        if (this.fn == null) {
            Preconditions.checkState(this.config.isEnabled(), "JavaScript is disabled");
            JavaScriptConfig javaScriptConfig = this.config;
            synchronized (javaScriptConfig) {
                if (this.fn == null) {
                    this.fn = JavaScriptPostAggregator.compile(this.function);
                }
            }
        }
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(6).appendStrings(this.fieldNames).appendString(this.function).build();
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public JavaScriptPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptPostAggregator that = (JavaScriptPostAggregator)o;
        if (!this.fieldNames.equals(that.fieldNames)) {
            return false;
        }
        if (!this.function.equals(that.function)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldNames.hashCode();
        result = 31 * result + this.function.hashCode();
        return result;
    }

    private static interface Function {
        public double apply(Object[] var1);
    }
}

