/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;

public class Queries {
    public static List<PostAggregator> decoratePostAggregators(List<PostAggregator> postAggs, Map<String, AggregatorFactory> aggFactories) {
        ArrayList<PostAggregator> decorated = Lists.newArrayListWithExpectedSize(postAggs.size());
        for (PostAggregator aggregator : postAggs) {
            decorated.add(aggregator.decorate(aggFactories));
        }
        return decorated;
    }

    @Deprecated
    public static List<PostAggregator> prepareAggregations(List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        return Queries.prepareAggregations(Collections.emptyList(), aggFactories, postAggs);
    }

    public static List<PostAggregator> prepareAggregations(List<String> otherOutputNames, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        Preconditions.checkNotNull(otherOutputNames, "otherOutputNames cannot be null");
        Preconditions.checkNotNull(aggFactories, "aggregations cannot be null");
        HashSet<String> combinedOutputNames = new HashSet<String>();
        combinedOutputNames.addAll(otherOutputNames);
        HashMap<String, AggregatorFactory> aggsFactoryMap = new HashMap<String, AggregatorFactory>();
        for (AggregatorFactory aggFactory : aggFactories) {
            Preconditions.checkArgument(combinedOutputNames.add(aggFactory.getName()), "[%s] already defined", new Object[]{aggFactory.getName()});
            aggsFactoryMap.put(aggFactory.getName(), aggFactory);
        }
        if (postAggs != null && !postAggs.isEmpty()) {
            ArrayList<PostAggregator> decorated = Lists.newArrayListWithExpectedSize(postAggs.size());
            for (PostAggregator postAgg : postAggs) {
                Set<String> dependencies = postAgg.getDependentFields();
                Sets.SetView<String> missing = Sets.difference(dependencies, combinedOutputNames);
                Preconditions.checkArgument(missing.isEmpty(), "Missing fields [%s] for postAggregator [%s]", new Object[]{missing, postAgg.getName()});
                Preconditions.checkArgument(combinedOutputNames.add(postAgg.getName()), "[%s] already defined", new Object[]{postAgg.getName()});
                decorated.add(postAgg.decorate(aggsFactoryMap));
            }
            return decorated;
        }
        return postAggs;
    }
}

