/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.metrics.cgroups;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.LongStream;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.RE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.java.util.metrics.CgroupUtil;
import org.apache.hive.druid.io.druid.java.util.metrics.cgroups.CgroupDiscoverer;

public class CpuAcct {
    private static final Logger LOG = new Logger(CpuAcct.class);
    private static final String CGROUP = "cpuacct";
    private static final String CGROUP_ACCT_FILE = "cpuacct.usage_all";
    private final CgroupDiscoverer cgroupDiscoverer;

    private static CpuAcctMetric parse(List<String> lines) {
        int ncpus = lines.size() - 1;
        long[] usrTime = new long[ncpus];
        long[] sysTime = new long[ncpus];
        for (int i = 1; i < lines.size(); ++i) {
            String[] splits = lines.get(i).split(CgroupUtil.SPACE_MATCH, 3);
            if (splits.length != 3) {
                throw new RE("Error parsing [%s]", lines.get(i));
            }
            int cpuNum = Integer.parseInt(splits[0]);
            usrTime[cpuNum] = Long.parseLong(splits[1]);
            sysTime[cpuNum] = Long.parseLong(splits[2]);
        }
        return new CpuAcctMetric(usrTime, sysTime);
    }

    public CpuAcct(CgroupDiscoverer cgroupDiscoverer) {
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public CpuAcctMetric snapshot() {
        File cpuacct;
        try {
            cpuacct = new File(this.cgroupDiscoverer.discover(CGROUP).toFile(), CGROUP_ACCT_FILE);
        }
        catch (RuntimeException re) {
            LOG.error(re, "Unable to fetch snapshot", new Object[0]);
            return new CpuAcctMetric(new long[0], new long[0]);
        }
        try {
            return CpuAcct.parse(Files.readAllLines(cpuacct.toPath(), Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CpuAcctMetric {
        private final long[] usrTimes;
        private final long[] sysTimes;

        CpuAcctMetric(long[] usrTimes, long[] sysTimes) {
            Preconditions.checkArgument(usrTimes.length == sysTimes.length, "Lengths must match");
            this.usrTimes = usrTimes;
            this.sysTimes = sysTimes;
        }

        public final int cpuCount() {
            return this.usrTimes.length;
        }

        public final long[] sysTimes() {
            return this.sysTimes;
        }

        public final long[] usrTimes() {
            return this.usrTimes;
        }

        public final long usrTime(int cpuNum) {
            return this.usrTimes[cpuNum];
        }

        public final long sysTime(int cpu_Num) {
            return this.sysTimes[cpu_Num];
        }

        public final long usrTime() {
            return LongStream.of(this.usrTimes).sum();
        }

        public final long sysTime() {
            return LongStream.of(this.sysTimes).sum();
        }

        public final long time() {
            return this.usrTime() + this.sysTime();
        }

        public final CpuAcctMetric cumulativeSince(CpuAcctMetric other) {
            int cpuCount = this.cpuCount();
            Preconditions.checkArgument(cpuCount == other.cpuCount(), "Cpu count missmatch");
            long[] sysTimes = new long[cpuCount];
            long[] usrTimes = new long[cpuCount];
            for (int i = 0; i < cpuCount; ++i) {
                sysTimes[i] = this.sysTimes[i] - other.sysTimes[i];
                usrTimes[i] = this.usrTimes[i] - other.usrTimes[i];
            }
            return new CpuAcctMetric(usrTimes, sysTimes);
        }
    }
}

