/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.emitter.core.HttpPostEmitter;

class Batch
extends AbstractQueuedLongSynchronizer {
    private static final long PARTY = 0x100000000L;
    private static final long SEAL_BIT = Long.MIN_VALUE;
    private static final long UNLOCK_TAG = 0L;
    private static final long UNLOCK_AND_SEAL_TAG = 1L;
    private static final long SEAL_TAG = 2L;
    private final HttpPostEmitter emitter;
    final byte[] buffer;
    final int batchNumber;
    final AtomicInteger eventCount = new AtomicInteger(0);
    private long firstEventTimestamp = -1L;

    private static int bufferWatermark(long state) {
        return (int)state;
    }

    private static int parties(long state) {
        return (int)(state >>> 32) & Integer.MAX_VALUE;
    }

    private static boolean isSealed(long state) {
        return state < 0L;
    }

    private static boolean isEmittingAllowed(long state) {
        return Batch.isSealed(state) && Batch.parties(state) == 0;
    }

    Batch(HttpPostEmitter emitter, byte[] buffer, int batchNumber) {
        this.emitter = emitter;
        this.buffer = buffer;
        this.batchNumber = batchNumber;
    }

    int getSealedBufferWatermark() {
        long state = this.getState();
        Preconditions.checkState(Batch.isSealed(state));
        return Batch.bufferWatermark(state);
    }

    boolean tryAddEvent(byte[] event) {
        block3: {
            while (true) {
                long state;
                if (Batch.isSealed(state = this.getState())) {
                    return false;
                }
                int bufferWatermark = Batch.bufferWatermark(state);
                if (bufferWatermark == 0) {
                    if (!this.tryAddFirstEvent(event)) continue;
                    return true;
                }
                if (this.newBufferWatermark(bufferWatermark, event) > this.emitter.maxBufferWatermark) break block3;
                if (this.tryAddNonFirstEvent(state, event)) break;
            }
            return true;
        }
        this.seal();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAddFirstEvent(byte[] event) {
        if (!this.tryReserveFirstEventSizeAndLock(event)) {
            return false;
        }
        try {
            int bufferOffset = this.emitter.batchingStrategy.writeBatchStart(this.buffer);
            this.writeEvent(event, bufferOffset);
            this.eventCount.incrementAndGet();
            this.firstEventTimestamp = System.currentTimeMillis();
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private boolean tryReserveFirstEventSizeAndLock(byte[] event) {
        return this.compareAndSetState(0L, (long)(this.emitter.batchingStrategy.batchStartLength() + event.length) + 0x100000000L);
    }

    private int newBufferWatermark(int bufferWatermark, byte[] eventBytes) {
        return bufferWatermark + this.emitter.batchingStrategy.separatorLength() + eventBytes.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAddNonFirstEvent(long state, byte[] event) {
        int bufferOffset = this.tryReserveEventSizeAndLock(state, this.emitter.batchingStrategy.separatorLength() + event.length);
        if (bufferOffset < 0) {
            return false;
        }
        try {
            bufferOffset = this.emitter.batchingStrategy.writeMessageSeparator(this.buffer, bufferOffset);
            this.writeEvent(event, bufferOffset);
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockAndSealIfNeeded();
        }
    }

    private int tryReserveEventSizeAndLock(long state, int size) {
        int newBufferWatermark;
        Preconditions.checkArgument(size > 0);
        int bufferWatermark = Batch.bufferWatermark(state);
        do {
            if (this.compareAndSetState(state, state + (long)size + 0x100000000L)) {
                return bufferWatermark;
            }
            state = this.getState();
            if (Batch.isSealed(state)) {
                return -1;
            }
            bufferWatermark = Batch.bufferWatermark(state);
            newBufferWatermark = bufferWatermark + size;
            Preconditions.checkState(newBufferWatermark > 0);
        } while (newBufferWatermark <= this.emitter.maxBufferWatermark);
        return -1;
    }

    private void unlockAndSealIfNeeded() {
        if (this.eventCount.incrementAndGet() >= this.emitter.config.getFlushCount()) {
            this.unlockAndSeal();
        } else {
            long timeSinceFirstEvent = System.currentTimeMillis() - this.firstEventTimestamp;
            if (this.firstEventTimestamp > 0L && timeSinceFirstEvent > this.emitter.config.getFlushMillis()) {
                this.unlockAndSeal();
            } else {
                this.unlock();
            }
        }
    }

    void sealIfFlushNeeded() {
        long timeSinceFirstEvent = System.currentTimeMillis() - this.firstEventTimestamp;
        if (this.firstEventTimestamp > 0L && timeSinceFirstEvent > this.emitter.config.getFlushMillis()) {
            this.seal();
        }
    }

    private void writeEvent(byte[] event, int bufferOffset) {
        System.arraycopy(event, 0, this.buffer, bufferOffset, event.length);
    }

    private void unlock() {
        this.releaseShared(0L);
    }

    private void unlockAndSeal() {
        this.releaseShared(1L);
    }

    void seal() {
        this.releaseShared(2L);
    }

    @Override
    protected boolean tryReleaseShared(long tag) {
        if (tag == 0L) {
            long newState;
            long state;
            do {
                int parties;
                if ((parties = Batch.parties(state = this.getState())) != 0) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(state, newState = state - 0x100000000L));
            return Batch.isEmittingAllowed(newState);
        }
        if (tag == 1L) {
            long newState;
            long state;
            do {
                int parties;
                if ((parties = Batch.parties(state = this.getState())) != 0) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(state, newState = state - 0x100000000L | Long.MIN_VALUE));
            if (!Batch.isSealed(state)) {
                this.emitter.onSealExclusive(this, this.firstEventTimestamp > 0L ? System.currentTimeMillis() - this.firstEventTimestamp : -1L);
            }
            return Batch.isEmittingAllowed(newState);
        }
        if (tag == 2L) {
            long newState;
            long state;
            do {
                if (!Batch.isSealed(state = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(state, newState = state | Long.MIN_VALUE));
            this.emitter.onSealExclusive(this, this.firstEventTimestamp > 0L ? System.currentTimeMillis() - this.firstEventTimestamp : -1L);
            return Batch.isEmittingAllowed(newState);
        }
        throw new IllegalStateException("Unknown tag: " + tag);
    }

    void awaitEmittingAllowed() {
        this.acquireShared(1L);
    }

    @Override
    protected long tryAcquireShared(long ignored) {
        return Batch.isEmittingAllowed(this.getState()) ? 1L : -1L;
    }

    @Override
    public String toString() {
        long state = this.getState();
        return "Batch{bufferWatermark=" + Batch.bufferWatermark(state) + ", parties=" + Batch.parties(state) + ", isSealed=" + Batch.isSealed(state) + "}";
    }
}

