/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hive.druid.com.metamx.common.concurrent.ExecutorServiceConfig;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;

public class ExecutorServices {
    public static ExecutorService create(Lifecycle lifecycle, ExecutorServiceConfig config) {
        return ExecutorServices.manageLifecycle(lifecycle, Executors.newFixedThreadPool(config.getNumThreads(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(config.getFormatString()).build()));
    }

    public static <T extends ExecutorService> T manageLifecycle(Lifecycle lifecycle, final T service) {
        try {
            lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                @Override
                public void start() throws Exception {
                }

                @Override
                public void stop() {
                    service.shutdownNow();
                }
            });
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
        return service;
    }
}

