/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public class HadoopFsWrapper {
    private static final Logger log = new Logger(HadoopFsWrapper.class);

    private HadoopFsWrapper() {
    }

    public static boolean rename(FileSystem fs, Path from, Path to, boolean replaceExisting) throws IOException {
        try {
            fs.rename(from, to, new Options.Rename[]{replaceExisting ? Options.Rename.OVERWRITE : Options.Rename.NONE});
            return true;
        }
        catch (FileAlreadyExistsException ex) {
            log.info(ex, "Destination exists while renaming [%s] to [%s]", from, to);
            return false;
        }
    }
}

