/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingBinderAgainstBind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestNewApiOnDbiAndHandle {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @Test
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testOpenNewSpiffy() throws Exception {
        Spiffy spiffy = (Spiffy)this.dbi.open(Spiffy.class);
        try {
            spiffy.insert(new Something(1, "Tim"));
            spiffy.insert(new Something(2, "Diego"));
            Assert.assertEquals((Object)"Diego", (Object)spiffy.findNameById(2));
        }
        finally {
            this.dbi.close((Object)spiffy);
        }
        Assert.assertTrue((boolean)spiffy.getHandle().getConnection().isClosed());
    }

    @Test
    public void testOnDemandSpiffy() throws Exception {
        Spiffy spiffy = (Spiffy)this.dbi.onDemand(Spiffy.class);
        spiffy.insert(new Something(1, "Tim"));
        spiffy.insert(new Something(2, "Diego"));
        Assert.assertEquals((Object)"Diego", (Object)spiffy.findNameById(2));
    }

    @Test
    public void testAttach() throws Exception {
        Spiffy spiffy = (Spiffy)this.handle.attach(Spiffy.class);
        spiffy.insert(new Something(1, "Tim"));
        spiffy.insert(new Something(2, "Diego"));
        Assert.assertEquals((Object)"Diego", (Object)spiffy.findNameById(2));
    }

    static interface Spiffy
    extends GetHandle {
        @SqlUpdate(value="insert into something (id, name) values (:it.id, :it.name)")
        public void insert(@Bind(value="it", binder=SomethingBinderAgainstBind.class) Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") int var1);
    }
}

