/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.subpackage.SomethingDao;

public class TestClassBasedSqlObject {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testPassThroughMethod() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.insert(3, "Cora");
        Something c = dao.findByIdHeeHee(3);
        Assert.assertThat((Object)c, (Matcher)CoreMatchers.equalTo((Object)new Something(3, "Cora")));
    }

    @Test(expected=AbstractMethodError.class)
    public void testUnimplementedMethod() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.totallyBroken();
    }

    @Test
    public void testPassThroughMethodWithDaoInAnotherPackage() throws Exception {
        SomethingDao dao = (SomethingDao)this.handle.attach(SomethingDao.class);
        dao.insert(3, "Cora");
        Something c = dao.findByIdHeeHee(3);
        Assert.assertThat((Object)c, (Matcher)CoreMatchers.equalTo((Object)new Something(3, "Cora")));
    }

    @Test(expected=AbstractMethodError.class)
    public void testUnimplementedMethodWithDaoInAnotherPackage() throws Exception {
        SomethingDao dao = (SomethingDao)this.handle.attach(SomethingDao.class);
        dao.totallyBroken();
    }

    @RegisterMapper(value={SomethingMapper.class})
    public static abstract class Dao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public abstract void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public abstract Something findById(@Bind(value="id") int var1);

        public Something findByIdHeeHee(int id) {
            return this.findById(id);
        }

        public abstract void totallyBroken();
    }
}

