/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestBeanBinder {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testInsert() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(new Something(2, "Bean"));
        String name = (String)this.handle.createQuery("select name from something where id = 2").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertEquals((Object)"Bean", (Object)name);
    }

    @Test
    public void testRead() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        this.handle.insert("insert into something (id, name) values (17, 'Phil')", new Object[0]);
        Something phil = s.findByEqualsOnBothFields(new Something(17, "Phil"));
        Assert.assertEquals((Object)"Phil", (Object)phil.getName());
    }

    static interface Spiffy {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@BindBean Something var1);

        @SqlQuery(value="select id, name from something where id = :s.id and name = :s.name")
        public Something findByEqualsOnBothFields(@BindBean(value="s") Something var1);
    }
}

