/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.docs;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.NamedArgumentFinder;

public class TestBindExpression {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.handle = this.dbi.open();
        this.handle.execute("create table something( id integer primary key, name varchar(100) )", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    @Test
    public void testExpression() throws Exception {
        DB db = (DB)this.handle.attach(DB.class);
        db.insert(new Something(1, "syrup"), new Something(2, "whipped cream"));
        Something with_syrup = db.findByBreakfast(new Breakfast());
        Assert.assertThat((Object)with_syrup, (Matcher)CoreMatchers.equalTo((Object)new Something(1, "syrup")));
    }

    @Test
    public void testJexl() throws Exception {
        JexlEngine engine = new JexlEngine();
        Object topping = engine.createExpression("breakfast.waffle.topping").evaluate((JexlContext)new MapContext((Map)ImmutableMap.of((Object)"breakfast", (Object)new Breakfast())));
        Assert.assertThat((Object)topping, (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)((String)topping), (Matcher)CoreMatchers.equalTo((Object)"syrup"));
    }

    public static class Waffle {
        private String topping = "syrup";

        public String getTopping() {
            return this.topping;
        }
    }

    public static class Breakfast {
        private final Waffle waffle = new Waffle();

        public Waffle getWaffle() {
            return this.waffle;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlStatementCustomizingAnnotation(value=BindExpressionCustomizerFactory.class)
    public static @interface BindRoot {
        public String value();

        public static class BindExpressionCustomizerFactory
        implements SqlStatementCustomizerFactory {
            public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
                throw new UnsupportedOperationException("Not Yet Implemented!");
            }

            public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
                throw new UnsupportedOperationException("Not Yet Implemented!");
            }

            public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, final Object root) {
                final String root_name = ((BindRoot)annotation).value();
                final JexlEngine engine = new JexlEngine();
                return new SqlStatementCustomizer(){

                    public void apply(SQLStatement q) throws SQLException {
                        q.bindNamedArgumentFinder(new NamedArgumentFinder(){

                            public Argument find(String name) {
                                Expression e = engine.createExpression(name);
                                final Object it = e.evaluate((JexlContext)new MapContext((Map)ImmutableMap.of((Object)root_name, (Object)root)));
                                if (it != null) {
                                    return new Argument(){

                                        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
                                            statement.setObject(position, it);
                                        }
                                    };
                                }
                                return null;
                            }
                        });
                    }
                };
            }
        }
    }

    @RegisterMapper(value={SomethingMapper.class})
    public static interface DB {
        @SqlBatch(value="insert into something (id, name) values(:id, :name)")
        public void insert(Something ... var1);

        @SqlQuery(value="select id, name from something where name = :breakfast.waffle.topping limit 1")
        public Something findByBreakfast(@BindRoot(value="breakfast") Breakfast var1);
    }
}

