/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.HandyMapThing;
import org.skife.jdbi.derby.DerbyHelper;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestPreparedBatch
extends DBITestCase {
    @Test
    public void testDesignApi() throws Exception {
        BasicHandle h = this.openHandle();
        PreparedBatch b = h.prepareBatch("insert into something (id, name) values (:id, :name)");
        PreparedBatchPart p = b.add();
        p = ((PreparedBatchPart)((PreparedBatchPart)p.bind("id", 1)).bind("name", "Eric")).next();
        ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)p.bind("id", 2)).bind("name", "Brian")).next().bind("id", 3)).bind("name", "Keith");
        b.execute();
        List r = h.createQuery("select * from something order by id").map(Something.class).list();
        Assert.assertEquals((long)3L, (long)r.size());
        Assert.assertEquals((Object)"Keith", (Object)((Something)r.get(2)).getName());
    }

    @Test
    public void testBigishBatch() throws Exception {
        BasicHandle h = this.openHandle();
        PreparedBatch b = h.prepareBatch("insert into something (id, name) values (:id, :name)");
        int count = 100;
        for (int i = 0; i < count; ++i) {
            ((PreparedBatchPart)b.add().bind("id", i)).bind("name", "A Name");
        }
        b.execute();
        int row_count = (Integer)h.createQuery("select count(id) from something").map((ResultSetMapper)new ResultSetMapper<Integer>(){

            public Integer map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                return r.getInt(1);
            }
        }).first();
        Assert.assertEquals((long)count, (long)row_count);
    }

    @Test
    public void testBindProperties() throws Exception {
        BasicHandle h = this.openHandle();
        PreparedBatch b = h.prepareBatch("insert into something (id, name) values (?, ?)");
        b.add(new Object[]{0, "Keith"});
        b.add(new Object[]{1, "Eric"});
        b.add(new Object[]{2, "Brian"});
        b.execute();
        List r = h.createQuery("select * from something order by id").map(Something.class).list();
        Assert.assertEquals((long)3L, (long)r.size());
        Assert.assertEquals((Object)"Brian", (Object)((Something)r.get(2)).getName());
    }

    @Test
    public void testBindMaps() throws Exception {
        BasicHandle h = this.openHandle();
        PreparedBatch b = h.prepareBatch("insert into something (id, name) values (:id, :name)");
        HandyMapThing<String> one = DerbyHelper.map("id", 0).add("name", "Keith");
        b.add(one);
        b.add(DerbyHelper.map("id", Integer.parseInt("1")).add("name", "Eric"));
        b.add(DerbyHelper.map("id", Integer.parseInt("2")).add("name", "Brian"));
        b.execute();
        List r = h.createQuery("select * from something order by id").map(Something.class).list();
        Assert.assertEquals((long)3L, (long)r.size());
        Assert.assertEquals((Object)"Brian", (Object)((Something)r.get(2)).getName());
    }

    @Test
    public void testMixedModeBatch() throws Exception {
        BasicHandle h = this.openHandle();
        PreparedBatch b = h.prepareBatch("insert into something (id, name) values (:id, :name)");
        HandyMapThing<String> one = DerbyHelper.map("id", 0);
        b.add(one).bind("name", "Keith");
        b.execute();
        List r = h.createQuery("select * from something order by id").map(Something.class).list();
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((Object)"Keith", (Object)((Something)r.get(0)).getName());
    }

    @Test
    public void testPositionalBinding() throws Exception {
        BasicHandle h = this.openHandle();
        PreparedBatch b = h.prepareBatch("insert into something (id, name) values (:id, :name)");
        ((PreparedBatchPart)((PreparedBatchPart)b.add().bind(0, 0)).bind(1, "Keith")).submit().execute();
        List r = h.createQuery("select * from something order by id").map(Something.class).list();
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((Object)"Keith", (Object)((Something)r.get(0)).getName());
    }

    @Test
    public void testSetOnTheBatchItself() throws Exception {
        BasicHandle h = this.openHandle();
        PreparedBatch b = h.prepareBatch("insert into something (id, name) values (:id, :name)");
        b.bind("id", 1);
        b.bind("name", "Jeff");
        b.add();
        b.bind("id", 2);
        b.bind("name", "Tom");
        b.add();
        b.execute();
        Assert.assertEquals((Object)h.createQuery("select name from something order by id").map((ResultSetMapper)StringMapper.FIRST).list(), Arrays.asList("Jeff", "Tom"));
    }

    @Test
    public void testMixedBatchSetting() throws Exception {
        BasicHandle h = this.openHandle();
        PreparedBatch b = h.prepareBatch("insert into something (id, name) values (:id, :name)");
        b.bind("id", 1);
        b.add().bind("name", "Jeff");
        b.bind("id", 2);
        b.add().bind("name", "Tom");
        b.execute();
        Assert.assertEquals((Object)h.createQuery("select name from something order by id").map((ResultSetMapper)StringMapper.FIRST).list(), Arrays.asList("Jeff", "Tom"));
    }
}

