/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestHandle
extends DBITestCase {
    @Test
    public void testInTransaction() throws Exception {
        BasicHandle h = this.openHandle();
        String value = (String)h.inTransaction((TransactionCallback)new TransactionCallback<String>(){

            public String inTransaction(Handle handle, TransactionStatus status) throws Exception {
                handle.insert("insert into something (id, name) values (1, 'Brian')", new Object[0]);
                return ((Something)handle.createQuery("select name from something where id = 1").map(Something.class).first()).getName();
            }
        });
        Assert.assertEquals((Object)"Brian", (Object)value);
    }

    @Test
    public void testSillyNumberOfCallbacks() throws Exception {
        BasicHandle h = this.openHandle();
        h.insert("insert into something (id, name) values (1, 'Keith')", new Object[0]);
        h.close();
        String value = (String)new DBI(DERBY_HELPER.getJdbcConnectionString()).withHandle((HandleCallback)new HandleCallback<String>(){

            public String withHandle(Handle handle) throws Exception {
                return (String)handle.inTransaction((TransactionCallback)new TransactionCallback<String>(){

                    public String inTransaction(Handle handle, TransactionStatus status) throws Exception {
                        return (String)handle.createQuery("select name from something where id = 1").map((ResultSetMapper)new ResultSetMapper<String>(){

                            public String map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                                return r.getString(1);
                            }
                        }).first();
                    }
                });
            }
        });
        Assert.assertEquals((Object)"Keith", (Object)value);
    }
}

