/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.tweak.ConnectionFactory;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.HandleConsumer;

public class TestDBI
extends DBITestCase {
    @Test
    public void testDataSourceConstructor() throws Exception {
        DBI dbi = new DBI(DERBY_HELPER.getDataSource());
        Handle h = dbi.open();
        Assert.assertNotNull((Object)h);
        h.close();
    }

    @Test
    public void testConnectionFactoryCtor() throws Exception {
        DBI dbi = new DBI(new ConnectionFactory(){

            public Connection openConnection() {
                try {
                    return DBITestCase.DERBY_HELPER.getConnection();
                }
                catch (SQLException e) {
                    throw new UnableToObtainConnectionException((Throwable)e);
                }
            }
        });
        Handle h = dbi.open();
        Assert.assertNotNull((Object)h);
        h.close();
    }

    @Test
    public void testCorrectExceptionOnSQLException() throws Exception {
        DBI dbi = new DBI(new ConnectionFactory(){

            public Connection openConnection() throws SQLException {
                throw new SQLException();
            }
        });
        try {
            dbi.open();
            Assert.fail((String)"Should have raised an exception");
        }
        catch (UnableToObtainConnectionException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testStaticHandleOpener() throws Exception {
        Handle h = DBI.open((DataSource)DERBY_HELPER.getDataSource());
        Assert.assertNotNull((Object)h);
        h.close();
    }

    @Test
    public void testWithHandle() throws Exception {
        DBI dbi = new DBI(DERBY_HELPER.getDataSource());
        String value = (String)dbi.withHandle((HandleCallback)new HandleCallback<String>(){

            public String withHandle(Handle handle) throws Exception {
                handle.insert("insert into something (id, name) values (1, 'Brian')", new Object[0]);
                return ((Something)handle.createQuery("select name from something where id = 1").map(Something.class).first()).getName();
            }
        });
        Assert.assertEquals((Object)"Brian", (Object)value);
    }

    @Test
    public void testUseHandle() throws Exception {
        DBI dbi = new DBI(DERBY_HELPER.getDataSource());
        dbi.useHandle(new HandleConsumer(){

            public void useHandle(Handle handle) throws Exception {
                handle.insert("insert into something (id, name) values (1, 'Brian')", new Object[0]);
                String value = ((Something)handle.createQuery("select name from something where id = 1").map(Something.class).first()).getName();
                Assert.assertEquals((Object)"Brian", (Object)value);
            }
        });
    }
}

