/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;

public class TestClosingHandle
extends DBITestCase {
    private BasicHandle h;

    @Override
    public void doSetUp() throws Exception {
        this.h = this.openHandle();
    }

    @Override
    public void doTearDown() throws Exception {
        if (this.h != null) {
            this.h.close();
        }
    }

    @Test
    public void testNotClosing() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        List results = this.h.createQuery("select * from something order by id").list();
        Assert.assertEquals((long)2L, (long)results.size());
        Map first_row = (Map)results.get(0);
        Assert.assertEquals((Object)"eric", first_row.get("name"));
        Assert.assertFalse((boolean)this.h.isClosed());
    }

    @Test
    public void testClosing() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        List results = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).list();
        Assert.assertEquals((long)2L, (long)results.size());
        Map first_row = (Map)results.get(0);
        Assert.assertEquals((Object)"eric", first_row.get("name"));
        Assert.assertTrue((boolean)this.h.isClosed());
    }

    @Test
    public void testIterateKeepHandle() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        ResultIterator it = this.h.createQuery("select * from something order by id").iterator();
        int cnt = 0;
        while (it.hasNext()) {
            ++cnt;
            it.next();
        }
        Assert.assertEquals((long)2L, (long)cnt);
        Assert.assertFalse((boolean)this.h.isClosed());
    }

    @Test
    public void testIterateAllTheWay() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        int cnt = 0;
        while (it.hasNext()) {
            ++cnt;
            it.next();
        }
        Assert.assertEquals((long)2L, (long)cnt);
        Assert.assertTrue((boolean)this.h.isClosed());
    }

    @Test
    public void testIteratorBehaviour() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)this.h.isClosed());
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)this.h.isClosed());
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)this.h.isClosed());
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertTrue((boolean)this.h.isClosed());
    }

    @Test
    public void testIteratorClose() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)this.h.isClosed());
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertFalse((boolean)this.h.isClosed());
        it.close();
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertTrue((boolean)this.h.isClosed());
    }
}

