/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.AbstractBasicTest;
import org.asynchttpclient.ws.EchoSocket;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketTextListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TextMessageTest
extends AbstractBasicTest {
    @Override
    public WebSocketHandler getWebSocketHandler() {
        return new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                factory.register(EchoSocket.class);
            }
        };
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void onOpen() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                    text.set("OnOpen");
                    latch.countDown();
                }

                public void onClose(WebSocket websocket) {
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnOpen");
        }
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void onEmptyListenerTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            WebSocket websocket = null;
            try {
                websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().build()).get();
            }
            catch (Throwable t) {
                Assert.fail();
            }
            Assert.assertTrue((websocket != null ? 1 : 0) != 0);
        }
    }

    @Test(groups={"standalone"}, timeOut=60000L, expectedExceptions={UnknownHostException.class})
    public void onFailureTest() throws Throwable {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            c.prepareGet("ws://abcdefg").execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().build()).get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void onTimeoutCloseTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    text.set("OnClose");
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnClose");
        }
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void onClose() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener(new WebSocketListener(){

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    text.set("OnClose");
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.close();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"OnClose");
        }
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void echoText() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set(message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO");
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHO");
        }
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void echoDoubleListenerText() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set(message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set((String)text.get() + message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO");
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    @Test(groups={"standalone"})
    public void echoTwoMessagesTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(2);
            final AtomicReference<String> text = new AtomicReference<String>("");
            c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set((String)text.get() + message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                    websocket.sendMessage("ECHO").sendMessage("ECHO");
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    public void echoFragments() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set(message);
                    latch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    latch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    latch.countDown();
                }
            }).build()).get();
            websocket.stream("ECHO", false);
            websocket.stream("ECHO", true);
            latch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHOECHO");
        }
    }

    @Test(groups={"standalone"}, timeOut=60000L)
    public void echoTextAndThenClose() throws Throwable {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            final CountDownLatch textLatch = new CountDownLatch(1);
            final CountDownLatch closeLatch = new CountDownLatch(1);
            final AtomicReference<String> text = new AtomicReference<String>("");
            WebSocket websocket = (WebSocket)c.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WebSocketTextListener(){

                public void onMessage(String message) {
                    text.set((String)text.get() + message);
                    textLatch.countDown();
                }

                public void onOpen(WebSocket websocket) {
                }

                public void onClose(WebSocket websocket) {
                    closeLatch.countDown();
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                    closeLatch.countDown();
                }
            }).build()).get();
            websocket.sendMessage("ECHO");
            textLatch.await();
            websocket.sendMessage("CLOSE");
            closeLatch.await();
            Assert.assertEquals((String)text.get(), (String)"ECHO");
        }
    }
}

