/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.testserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class HttpServer
implements Closeable {
    private int httpPort;
    private int httpsPort;
    private Server server;
    private final ConcurrentLinkedQueue<Handler> handlers = new ConcurrentLinkedQueue();

    public HttpServer() {
    }

    public HttpServer(int httpPort, int httpsPort) {
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
    }

    public void start() throws Exception {
        this.server = new Server();
        ServerConnector httpConnector = TestUtils.addHttpConnector(this.server);
        if (this.httpPort != 0) {
            httpConnector.setPort(this.httpPort);
        }
        this.server.setHandler((Handler)new QueueHandler());
        ServerConnector httpsConnector = TestUtils.addHttpsConnector(this.server);
        if (this.httpsPort != 0) {
            httpsConnector.setPort(this.httpsPort);
        }
        this.server.start();
        this.httpPort = httpConnector.getLocalPort();
        this.httpsPort = httpsConnector.getLocalPort();
    }

    public void enqueue(Handler handler) {
        this.handlers.offer(handler);
    }

    public void enqueueOk() {
        this.enqueueResponse(response -> response.setStatus(200));
    }

    public void enqueueResponse(HttpServletResponseConsumer c) {
        this.handlers.offer((Handler)new ConsumerHandler(c));
    }

    public void enqueueEcho() {
        this.handlers.offer((Handler)new EchoHandler());
    }

    public void enqueueRedirect(int status, String location) {
        this.enqueueResponse(response -> {
            response.setStatus(status);
            response.setHeader("Location", location);
        });
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getsHttpPort() {
        return this.httpsPort;
    }

    public String getHttpUrl() {
        return "http://localhost:" + this.httpPort;
    }

    public String getHttpsUrl() {
        return "https://localhost:" + this.httpsPort;
    }

    public void reset() {
        this.handlers.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static class EchoHandler
    extends AutoFlushHandler {
        @Override
        protected void handle0(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String queryString;
            String delay = request.getHeader("X-Delay");
            if (delay != null) {
                try {
                    Thread.sleep(Long.parseLong(delay));
                }
                catch (InterruptedException | NumberFormatException e1) {
                    throw new ServletException((Throwable)e1);
                }
            }
            response.setStatus(200);
            if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
                response.addHeader("Allow", "GET,HEAD,POST,OPTIONS,TRACE");
            }
            response.setContentType(request.getHeader("X-IsoCharset") != null ? "text/html;charset=ISO-8859-1" : "text/html;charset=UTF-8");
            response.addHeader("X-ClientPort", String.valueOf(request.getRemotePort()));
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                response.addHeader("X-PathInfo", pathInfo);
            }
            if ((queryString = request.getQueryString()) != null) {
                response.addHeader("X-QueryString", queryString);
            }
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                response.addHeader("X-" + (String)headerName, request.getHeader(headerName));
            }
            for (Map.Entry entry : baseRequest.getParameterMap().entrySet()) {
                response.addHeader("X-" + (String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            Cookie[] cs = request.getCookies();
            if (cs != null) {
                for (Cookie c : cs) {
                    response.addCookie(c);
                }
            }
            Enumeration enumeration = request.getParameterNames();
            StringBuilder requestBody = new StringBuilder();
            while (enumeration.hasMoreElements()) {
                String param = (String)enumeration.nextElement();
                response.addHeader("X-" + param, request.getParameter(param));
                requestBody.append(param);
                requestBody.append("_");
            }
            if (requestBody.length() > 0) {
                response.getOutputStream().write(requestBody.toString().getBytes());
            }
            int size = 16384;
            if (request.getContentLength() > 0) {
                size = request.getContentLength();
            }
            if (size > 0) {
                byte[] bytes = new byte[size];
                int read = 0;
                while (read > -1) {
                    read = request.getInputStream().read(bytes);
                    if (read <= 0) continue;
                    response.getOutputStream().write(bytes, 0, read);
                }
            }
        }
    }

    private static class ConsumerHandler
    extends AutoFlushHandler {
        private final HttpServletResponseConsumer c;

        public ConsumerHandler(HttpServletResponseConsumer c) {
            this(c, false);
        }

        public ConsumerHandler(HttpServletResponseConsumer c, boolean closeAfterResponse) {
            super(closeAfterResponse);
            this.c = c;
        }

        @Override
        protected void handle0(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.c.apply(response);
        }
    }

    public static abstract class AutoFlushHandler
    extends AbstractHandler {
        private final boolean closeAfterResponse;

        public AutoFlushHandler() {
            this(false);
        }

        public AutoFlushHandler(boolean closeAfterResponse) {
            this.closeAfterResponse = closeAfterResponse;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.handle0(target, baseRequest, request, response);
            response.getOutputStream().flush();
            if (this.closeAfterResponse) {
                response.getOutputStream().close();
            }
        }

        protected abstract void handle0(String var1, Request var2, HttpServletRequest var3, HttpServletResponse var4) throws IOException, ServletException;
    }

    private class QueueHandler
    extends AbstractHandler {
        private QueueHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            Handler handler = (Handler)HttpServer.this.handlers.poll();
            if (handler == null) {
                response.sendError(500, "No handler enqueued");
                response.getOutputStream().flush();
                response.getOutputStream().close();
            } else {
                handler.handle(target, baseRequest, request, response);
            }
        }
    }

    @FunctionalInterface
    public static interface HttpServletResponseConsumer {
        public void apply(HttpServletResponse var1) throws IOException, ServletException;
    }
}

