/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.oauth;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilderBase;
import org.asynchttpclient.SignatureCalculator;
import org.asynchttpclient.oauth.ConsumerKey;
import org.asynchttpclient.oauth.OAuthSignatureCalculatorInstance;
import org.asynchttpclient.oauth.RequestToken;

class StaticOAuthSignatureCalculator
implements SignatureCalculator {
    private final ConsumerKey consumerKey;
    private final RequestToken requestToken;
    private final String nonce;
    private final long timestamp;

    public StaticOAuthSignatureCalculator(ConsumerKey consumerKey, RequestToken requestToken, String nonce, long timestamp) {
        this.consumerKey = consumerKey;
        this.requestToken = requestToken;
        this.nonce = nonce;
        this.timestamp = timestamp;
    }

    public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        try {
            new OAuthSignatureCalculatorInstance().sign(this.consumerKey, this.requestToken, request, requestBuilder, this.nonce, this.timestamp);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

