/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RetryNonBlockingIssue
extends AbstractBasicTest {
    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(new ServletHolder((Servlet)new MockExceptionServlet()), "/*");
        this.server.setHandler((Handler)context);
        this.server.start();
        this.port1 = connector.getLocalPort();
    }

    @Override
    protected String getTargetUrl() {
        return String.format("http://localhost:%d/", this.port1);
    }

    private ListenableFuture<Response> testMethodRequest(AsyncHttpClient client, int requests, String action, String id) throws IOException {
        RequestBuilder r = (RequestBuilder)((RequestBuilder)((RequestBuilder)Dsl.get((String)this.getTargetUrl()).addQueryParam(action, "1")).addQueryParam("maxRequests", "" + requests)).addQueryParam("id", id);
        return client.executeRequest(r);
    }

    @Test(groups={"standalone"})
    public void testRetryNonBlocking() throws IOException, InterruptedException, ExecutionException {
        DefaultAsyncHttpClientConfig config = Dsl.config().setKeepAlive(true).setMaxConnections(100).setConnectTimeout(60000).setRequestTimeout(30000).build();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            ArrayList<ListenableFuture<Response>> res = new ArrayList<ListenableFuture<Response>>();
            for (int i = 0; i < 32; ++i) {
                res.add(this.testMethodRequest(client, 3, "servlet", UUID.randomUUID().toString()));
            }
            StringBuilder b = new StringBuilder();
            for (ListenableFuture listenableFuture : res) {
                Response theres = (Response)listenableFuture.get();
                Assert.assertEquals((int)200, (int)theres.getStatusCode());
                b.append("==============\r\n");
                b.append("Response Headers\r\n");
                HttpHeaders heads = theres.getHeaders();
                b.append(heads + "\r\n");
                b.append("==============\r\n");
            }
            System.out.println(b.toString());
            System.out.flush();
        }
    }

    @Test(groups={"standalone"})
    public void testRetryNonBlockingAsyncConnect() throws IOException, InterruptedException, ExecutionException {
        DefaultAsyncHttpClientConfig config = Dsl.config().setKeepAlive(true).setMaxConnections(100).setConnectTimeout(60000).setRequestTimeout(30000).build();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            ArrayList<ListenableFuture<Response>> res = new ArrayList<ListenableFuture<Response>>();
            for (int i = 0; i < 32; ++i) {
                res.add(this.testMethodRequest(client, 3, "servlet", UUID.randomUUID().toString()));
            }
            StringBuilder b = new StringBuilder();
            for (ListenableFuture listenableFuture : res) {
                Response theres = (Response)listenableFuture.get();
                Assert.assertEquals((int)theres.getStatusCode(), (int)200);
                b.append("==============\r\n");
                b.append("Response Headers\r\n");
                HttpHeaders heads = theres.getHeaders();
                b.append(heads + "\r\n");
                b.append("==============\r\n");
            }
            System.out.println(b.toString());
            System.out.flush();
        }
    }

    public class MockExceptionServlet
    extends HttpServlet {
        private Map<String, Integer> requests = new ConcurrentHashMap<String, Integer>();

        private synchronized int increment(String id) {
            int val = 0;
            if (this.requests.containsKey(id)) {
                Integer i = this.requests.get(id);
                val = i + 1;
                this.requests.put(id, val);
            } else {
                this.requests.put(id, 1);
                val = 1;
            }
            System.out.println("REQUESTS: " + this.requests);
            return val;
        }

        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            String maxRequests = req.getParameter("maxRequests");
            int max = 0;
            try {
                max = Integer.parseInt(maxRequests);
            }
            catch (NumberFormatException e) {
                max = 3;
            }
            String id = req.getParameter("id");
            int requestNo = this.increment(id);
            String servlet = req.getParameter("servlet");
            String io = req.getParameter("io");
            String error = req.getParameter("500");
            if (requestNo >= max) {
                res.setHeader("Success-On-Attempt", "" + requestNo);
                res.setHeader("id", id);
                if (servlet != null && servlet.trim().length() > 0) {
                    res.setHeader("type", "servlet");
                }
                if (error != null && error.trim().length() > 0) {
                    res.setHeader("type", "500");
                }
                if (io != null && io.trim().length() > 0) {
                    res.setHeader("type", "io");
                }
                res.setStatus(200);
                res.setContentLength(0);
                res.flushBuffer();
                return;
            }
            res.setStatus(200);
            res.setContentLength(100);
            res.setContentType("application/octet-stream");
            res.flushBuffer();
            if (servlet != null && servlet.trim().length() > 0) {
                throw new ServletException("Servlet Exception");
            }
            if (io != null && io.trim().length() > 0) {
                throw new IOException("IO Exception");
            }
            if (error != null && error.trim().length() > 0) {
                res.sendError(500, "servlet process was 500");
            }
        }
    }
}

