/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.channel;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MaxConnectionsInThreads
extends AbstractBasicTest {
    @Test(groups={"standalone"})
    public void testMaxConnectionsWithinThreads() throws Exception {
        String[] urls = new String[]{this.getTargetUrl(), this.getTargetUrl()};
        DefaultAsyncHttpClientConfig config = Dsl.config().setConnectTimeout(1000).setRequestTimeout(5000).setKeepAlive(true).setMaxConnections(1).setMaxConnectionsPerHost(1).build();
        final CountDownLatch inThreadsLatch = new CountDownLatch(2);
        final AtomicInteger failedCount = new AtomicInteger();
        try (final AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            for (final String url : urls) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        client.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                            public Response onCompleted(Response response) throws Exception {
                                Response r = super.onCompleted(response);
                                inThreadsLatch.countDown();
                                return r;
                            }

                            public void onThrowable(Throwable t) {
                                super.onThrowable(t);
                                failedCount.incrementAndGet();
                                inThreadsLatch.countDown();
                            }
                        });
                    }
                };
                t.start();
            }
            inThreadsLatch.await();
            Assert.assertEquals((int)failedCount.get(), (int)1, (String)"Max Connections should have been reached when launching from concurrent threads");
            final CountDownLatch notInThreadsLatch = new CountDownLatch(2);
            failedCount.set(0);
            for (String url : urls) {
                client.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                    public Response onCompleted(Response response) throws Exception {
                        Response r = super.onCompleted(response);
                        notInThreadsLatch.countDown();
                        return r;
                    }

                    public void onThrowable(Throwable t) {
                        super.onThrowable(t);
                        failedCount.incrementAndGet();
                        notInThreadsLatch.countDown();
                    }
                });
            }
            notInThreadsLatch.await();
            Assert.assertEquals((int)failedCount.get(), (int)1, (String)"Max Connections should have been reached when launching from main thread");
        }
    }

    @Override
    @BeforeClass
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MockTimeoutHttpServlet()), "/timeout/*");
        this.server.start();
        this.port1 = connector.getLocalPort();
    }

    @Override
    public String getTargetUrl() {
        return "http://localhost:" + this.port1 + "/timeout/";
    }

    public static class MockTimeoutHttpServlet
    extends HttpServlet {
        private static final Logger LOGGER = LoggerFactory.getLogger(MockTimeoutHttpServlet.class);
        private static final String contentType = "text/plain";
        public static long DEFAULT_TIMEOUT = 2000L;

        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            res.setStatus(200);
            res.addHeader("Content-Type", contentType);
            long sleepTime = DEFAULT_TIMEOUT;
            try {
                sleepTime = Integer.parseInt(req.getParameter("timeout"));
            }
            catch (NumberFormatException e) {
                sleepTime = DEFAULT_TIMEOUT;
            }
            try {
                LOGGER.debug("=======================================");
                LOGGER.debug("Servlet is sleeping for: " + sleepTime);
                LOGGER.debug("=======================================");
                Thread.sleep(sleepTime);
                LOGGER.debug("=======================================");
                LOGGER.debug("Servlet is awake for");
                LOGGER.debug("=======================================");
            }
            catch (Exception e) {
                // empty catch block
            }
            res.setHeader("XXX", "TripleX");
            byte[] retVal = "1".getBytes();
            ServletOutputStream os = res.getOutputStream();
            res.setContentLength(retVal.length);
            os.write(retVal);
            os.close();
        }
    }
}

