/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.ResponseFilter;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RedirectBodyTest
extends AbstractBasicTest {
    private String receivedContentType;
    private ResponseFilter redirectOnce = new ResponseFilter(){

        public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
            ctx.getRequest().getHeaders().remove("X-REDIRECT");
            return ctx;
        }
    };

    @BeforeMethod
    public void setUp() throws Exception {
        this.receivedContentType = null;
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new AbstractHandler(){

            public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
                String redirectHeader = httpRequest.getHeader("X-REDIRECT");
                if (redirectHeader != null) {
                    httpResponse.setStatus(Integer.valueOf(redirectHeader).intValue());
                    httpResponse.setContentLength(0);
                    httpResponse.setHeader("Location", RedirectBodyTest.this.getTargetUrl());
                } else {
                    httpResponse.setStatus(200);
                    int len = request.getContentLength();
                    httpResponse.setContentLength(len);
                    if (len > 0) {
                        byte[] buffer = new byte[len];
                        IOUtils.read((InputStream)request.getInputStream(), (byte[])buffer);
                        httpResponse.getOutputStream().write(buffer);
                    }
                    RedirectBodyTest.this.receivedContentType = request.getContentType();
                }
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
            }
        };
    }

    @Test(groups={"standalone"})
    public void regular301LosesBody() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).addResponseFilter(this.redirectOnce));){
            String body = "hello there";
            String contentType = "text/plain";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeader((CharSequence)"Content-Type", contentType)).setBody(body)).setHeader((CharSequence)"X-REDIRECT", "301")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)"");
            Assert.assertNull((Object)this.receivedContentType);
        }
    }

    @Test(groups={"standalone"})
    public void regular302LosesBody() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).addResponseFilter(this.redirectOnce));){
            String body = "hello there";
            String contentType = "text/plain";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeader((CharSequence)"Content-Type", contentType)).setBody(body)).setHeader((CharSequence)"X-REDIRECT", "302")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)"");
            Assert.assertNull((Object)this.receivedContentType);
        }
    }

    @Test(groups={"standalone"})
    public void regular302StrictKeepsBody() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).setStrict302Handling(true).addResponseFilter(this.redirectOnce));){
            String body = "hello there";
            String contentType = "text/plain";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeader((CharSequence)"Content-Type", contentType)).setBody(body)).setHeader((CharSequence)"X-REDIRECT", "302")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
            Assert.assertEquals((String)this.receivedContentType, (String)contentType);
        }
    }

    @Test(groups={"standalone"})
    public void regular307KeepsBody() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).addResponseFilter(this.redirectOnce));){
            String body = "hello there";
            String contentType = "text/plain";
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)c.preparePost(this.getTargetUrl()).setHeader((CharSequence)"Content-Type", contentType)).setBody(body)).setHeader((CharSequence)"X-REDIRECT", "307")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
            Assert.assertEquals((String)this.receivedContentType, (String)contentType);
        }
    }
}

