/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.MiscUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryParametersTest
extends AbstractBasicTest {
    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new QueryStringHandler();
    }

    @Test(groups={"standalone"})
    public void testQueryParameters() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)((BoundRequestBuilder)client.prepareGet("http://localhost:" + this.port1).addQueryParam("a", "1")).addQueryParam("b", "2")).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
            Assert.assertEquals((String)resp.getHeader("a"), (String)"1");
            Assert.assertEquals((String)resp.getHeader("b"), (String)"2");
        }
    }

    @Test(groups={"standalone"})
    public void testUrlRequestParametersEncoding() throws IOException, ExecutionException, InterruptedException {
        String URL2 = this.getTargetUrl() + "?q=";
        String REQUEST_PARAM = "github github \ngithub";
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            String requestUrl2 = URL2 + URLEncoder.encode(REQUEST_PARAM, StandardCharsets.UTF_8.name());
            this.logger.info("Executing request [{}] ...", (Object)requestUrl2);
            Response response = (Response)client.prepareGet(requestUrl2).execute().get();
            String s = URLDecoder.decode(response.getHeader("q"), StandardCharsets.UTF_8.name());
            Assert.assertEquals((String)s, (String)REQUEST_PARAM);
        }
    }

    @Test(groups={"standalone"})
    public void urlWithColonTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient();){
            String query = "test:colon:";
            Response response = (Response)((BoundRequestBuilder)c.prepareGet(String.format("http://localhost:%d/foo/test/colon?q=%s", this.port1, query)).setHeader((CharSequence)"Content-Type", "text/html")).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getHeader("q"), (String)query);
        }
    }

    private class QueryStringHandler
    extends AbstractHandler {
        private QueryStringHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("GET".equalsIgnoreCase(request.getMethod())) {
                String qs = request.getQueryString();
                if (MiscUtils.isNonEmpty((String)qs)) {
                    for (String qnv : qs.split("&")) {
                        String[] nv = qnv.split("=");
                        response.addHeader(nv[0], nv[1]);
                    }
                    response.setStatus(200);
                } else {
                    response.sendError(406);
                }
            } else {
                response.sendError(403);
            }
            r.setHandled(true);
        }
    }
}

