/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.DateUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PerRequestTimeoutTest
extends AbstractBasicTest {
    private static final String MSG = "Enough is enough.";

    private void checkTimeoutMessage(String message, boolean requestTimeout) {
        if (requestTimeout) {
            Assert.assertTrue((boolean)message.startsWith("Request timeout"), (String)("error message indicates reason of error but got: " + message));
        } else {
            Assert.assertTrue((boolean)message.startsWith("Read timeout"), (String)("error message indicates reason of error but got: " + message));
        }
        Assert.assertTrue((boolean)message.contains("localhost"), (String)("error message contains remote host address but got: " + message));
        Assert.assertTrue((boolean)message.contains("after 100 ms"), (String)("error message contains timeout configuration value but got: " + message));
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SlowHandler();
    }

    @Test(groups={"standalone"})
    public void testRequestTimeout() throws IOException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture responseFuture = ((BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRequestTimeout(100)).execute();
            Response response = (Response)responseFuture.get(2000L, TimeUnit.MILLISECONDS);
            Assert.assertNull((Object)response);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
            this.checkTimeoutMessage(e.getCause().getMessage(), true);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Timeout.", (Throwable)e);
        }
    }

    @Test(groups={"standalone"})
    public void testReadTimeout() throws IOException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setReadTimeout(100));){
            ListenableFuture responseFuture = client.prepareGet(this.getTargetUrl()).execute();
            Response response = (Response)responseFuture.get(2000L, TimeUnit.MILLISECONDS);
            Assert.assertNull((Object)response);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
            this.checkTimeoutMessage(e.getCause().getMessage(), false);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Timeout.", (Throwable)e);
        }
    }

    @Test(groups={"standalone"})
    public void testGlobalDefaultPerRequestInfiniteTimeout() throws IOException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(100));){
            ListenableFuture responseFuture = ((BoundRequestBuilder)client.prepareGet(this.getTargetUrl()).setRequestTimeout(-1)).execute();
            Response response = (Response)responseFuture.get();
            Assert.assertNotNull((Object)response);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
            this.checkTimeoutMessage(e.getCause().getMessage(), true);
        }
    }

    @Test(groups={"standalone"})
    public void testGlobalRequestTimeout() throws IOException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setRequestTimeout(100));){
            ListenableFuture responseFuture = client.prepareGet(this.getTargetUrl()).execute();
            Response response = (Response)responseFuture.get(2000L, TimeUnit.MILLISECONDS);
            Assert.assertNull((Object)response);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
            this.checkTimeoutMessage(e.getCause().getMessage(), true);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Timeout.", (Throwable)e);
        }
    }

    @Test(groups={"standalone"})
    public void testGlobalIdleTimeout() throws IOException {
        final long[] times = new long[]{-1L, -1L};
        try (AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setPooledConnectionIdleTimeout(2000));){
            ListenableFuture responseFuture = client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }

                public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    times[0] = DateUtils.unpreciseMillisTime();
                    return super.onBodyPartReceived(content);
                }

                public void onThrowable(Throwable t) {
                    times[1] = DateUtils.unpreciseMillisTime();
                    super.onThrowable(t);
                }
            });
            Response response = (Response)responseFuture.get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((String)response.getResponseBody(), (String)"Enough is enough.Enough is enough.");
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Interrupted.", (Throwable)e);
        }
        catch (ExecutionException e) {
            this.logger.info(String.format("\n@%dms Last body part received\n@%dms Connection killed\n %dms difference.", times[0], times[1], times[1] - times[0]));
            Assert.fail((String)"Timeouted on idle.", (Throwable)e);
        }
    }

    private class SlowHandler
    extends AbstractHandler {
        private SlowHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
            response.setStatus(200);
            final AsyncContext asyncContext = request.startAsync();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1500L);
                        response.getOutputStream().print(PerRequestTimeoutTest.MSG);
                        response.getOutputStream().flush();
                    }
                    catch (InterruptedException e) {
                        PerRequestTimeoutTest.this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        PerRequestTimeoutTest.this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                        response.getOutputStream().print(PerRequestTimeoutTest.MSG);
                        response.getOutputStream().flush();
                        asyncContext.complete();
                    }
                    catch (InterruptedException e) {
                        PerRequestTimeoutTest.this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        PerRequestTimeoutTest.this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }).start();
            baseRequest.setHandled(true);
        }
    }
}

