/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.test.RelBuilderTest;
import org.apache.hive.druid.org.apache.calcite.tools.FrameworkConfig;
import org.apache.hive.druid.org.apache.calcite.tools.Frameworks;
import org.apache.hive.druid.org.apache.calcite.tools.PigRelBuilder;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilder;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class PigRelBuilderTest {
    public static Frameworks.ConfigBuilder config() {
        return RelBuilderTest.config();
    }

    private String str(RelNode r) {
        return Util.toLinux((String)RelOptUtil.toString((RelNode)r));
    }

    @Test
    public void testScan() {
        PigRelBuilder builder = PigRelBuilder.create((FrameworkConfig)PigRelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).build();
        Assert.assertThat((Object)this.str(root), (Matcher)CoreMatchers.is((Object)"LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testCogroup() {
    }

    @Test
    public void testCross() {
    }

    @Test
    public void testCube() {
    }

    @Test
    public void testDefine() {
    }

    @Test
    public void testDistinct() {
        PigRelBuilder builder = PigRelBuilder.create((FrameworkConfig)PigRelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).project(new RexNode[]{builder.field("DEPTNO")}).distinct().build();
        String plan = "LogicalAggregate(group=[{0}])\n  LogicalProject(DEPTNO=[$7])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)this.str(root), (Matcher)CoreMatchers.is((Object)"LogicalAggregate(group=[{0}])\n  LogicalProject(DEPTNO=[$7])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testFilter() {
        PigRelBuilder builder = PigRelBuilder.create((FrameworkConfig)PigRelBuilderTest.config().build());
        RelNode root = builder.load("EMP.csv", null, null).filter(new RexNode[]{builder.isNotNull((RexNode)builder.field("MGR"))}).build();
        String plan = "LogicalFilter(condition=[IS NOT NULL($3)])\n  LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)this.str(root), (Matcher)CoreMatchers.is((Object)"LogicalFilter(condition=[IS NOT NULL($3)])\n  LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testForeach() {
    }

    @Test
    public void testGroup() {
        PigRelBuilder builder = PigRelBuilder.create((FrameworkConfig)PigRelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).group(null, null, -1, new RelBuilder.GroupKey[]{builder.groupKey(new String[]{"DEPTNO", "JOB"}).alias("e")}).build();
        String plan = "LogicalAggregate(group=[{2, 7}], EMP=[COLLECT($8)])\n  LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[ROW($0, $1, $2, $3, $4, $5, $6, $7)])\n    LogicalTableScan(table=[[scott, EMP]])\n";
        Assert.assertThat((Object)this.str(root), (Matcher)CoreMatchers.is((Object)"LogicalAggregate(group=[{2, 7}], EMP=[COLLECT($8)])\n  LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[ROW($0, $1, $2, $3, $4, $5, $6, $7)])\n    LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testGroup2() {
        PigRelBuilder builder = PigRelBuilder.create((FrameworkConfig)PigRelBuilderTest.config().build());
        RelNode root = builder.scan(new String[]{"EMP"}).scan(new String[]{"DEPT"}).group(null, null, -1, new RelBuilder.GroupKey[]{builder.groupKey(new String[]{"DEPTNO"}).alias("e"), builder.groupKey(new String[]{"DEPTNO"}).alias("d")}).build();
        String plan = "LogicalJoin(condition=[=($0, $2)], joinType=[inner])\n  LogicalAggregate(group=[{0}], EMP=[COLLECT($8)])\n    LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[ROW($0, $1, $2, $3, $4, $5, $6, $7)])\n      LogicalTableScan(table=[[scott, EMP]])\n  LogicalAggregate(group=[{0}], DEPT=[COLLECT($3)])\n    LogicalProject(DEPTNO=[$0], DNAME=[$1], LOC=[$2], $f3=[ROW($0, $1, $2)])\n      LogicalTableScan(table=[[scott, DEPT]])\n";
        Assert.assertThat((Object)this.str(root), (Matcher)CoreMatchers.is((Object)"LogicalJoin(condition=[=($0, $2)], joinType=[inner])\n  LogicalAggregate(group=[{0}], EMP=[COLLECT($8)])\n    LogicalProject(EMPNO=[$0], ENAME=[$1], JOB=[$2], MGR=[$3], HIREDATE=[$4], SAL=[$5], COMM=[$6], DEPTNO=[$7], $f8=[ROW($0, $1, $2, $3, $4, $5, $6, $7)])\n      LogicalTableScan(table=[[scott, EMP]])\n  LogicalAggregate(group=[{0}], DEPT=[COLLECT($3)])\n    LogicalProject(DEPTNO=[$0], DNAME=[$1], LOC=[$2], $f3=[ROW($0, $1, $2)])\n      LogicalTableScan(table=[[scott, DEPT]])\n"));
    }

    @Test
    public void testImport() {
    }

    @Test
    public void testJoinInner() {
    }

    @Test
    public void testJoinOuter() {
    }

    @Test
    public void testLimit() {
    }

    @Test
    public void testLoad() {
        PigRelBuilder builder = PigRelBuilder.create((FrameworkConfig)PigRelBuilderTest.config().build());
        RelNode root = builder.load("EMP.csv", null, null).build();
        Assert.assertThat((Object)this.str(root), (Matcher)CoreMatchers.is((Object)"LogicalTableScan(table=[[scott, EMP]])\n"));
    }

    @Test
    public void testMapReduce() {
    }

    @Test
    public void testOrderBy() {
    }

    @Test
    public void testRank() {
    }

    @Test
    public void testSample() {
    }

    @Test
    public void testSplit() {
    }

    @Test
    public void testStore() {
    }

    @Test
    public void testUnion() {
    }
}

