/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan.volcano;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.plan.Convention;
import org.apache.hive.druid.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCost;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanner;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.hive.druid.org.apache.calcite.plan.RelTrait;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitDef;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.PlannerTests;
import org.apache.hive.druid.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.junit.Assert;
import org.junit.Test;

public class TraitConversionTest {
    private static final ConvertRelDistributionTraitDef NEW_TRAIT_DEF_INSTANCE = new ConvertRelDistributionTraitDef();
    private static final SimpleDistribution SIMPLE_DISTRIBUTION_ANY = new SimpleDistribution("ANY");
    private static final SimpleDistribution SIMPLE_DISTRIBUTION_RANDOM = new SimpleDistribution("RANDOM");
    private static final SimpleDistribution SIMPLE_DISTRIBUTION_SINGLETON = new SimpleDistribution("SINGLETON");

    @Test
    public void testTraitConversion() {
        VolcanoPlanner planner = new VolcanoPlanner();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)NEW_TRAIT_DEF_INSTANCE);
        planner.addRule((RelOptRule)new RandomSingleTraitRule());
        planner.addRule((RelOptRule)new SingleLeafTraitRule());
        planner.addRule((RelOptRule)AbstractConverter.ExpandConversionRule.INSTANCE);
        RelOptCluster cluster = PlannerTests.newCluster(planner);
        NoneLeafRel leafRel = new NoneLeafRel(cluster, "a");
        NoneSingleRel singleRel = new NoneSingleRel(cluster, (RelNode)leafRel);
        RelNode convertedRel = planner.changeTraits((RelNode)singleRel, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        planner.setRoot(convertedRel);
        RelNode result = planner.chooseDelegate().findBestExp();
        Assert.assertTrue((boolean)(result instanceof RandomSingleRel));
        Assert.assertTrue((boolean)result.getTraitSet().contains((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        Assert.assertTrue((boolean)result.getTraitSet().contains((RelTrait)SIMPLE_DISTRIBUTION_RANDOM));
        RelNode input = result.getInput(0);
        Assert.assertTrue((boolean)(input instanceof BridgeRel));
        Assert.assertTrue((boolean)input.getTraitSet().contains((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        Assert.assertTrue((boolean)input.getTraitSet().contains((RelTrait)SIMPLE_DISTRIBUTION_RANDOM));
        RelNode input2 = input.getInput(0);
        Assert.assertTrue((boolean)(input2 instanceof SingletonLeafRel));
        Assert.assertTrue((boolean)input2.getTraitSet().contains((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION));
        Assert.assertTrue((boolean)input2.getTraitSet().contains((RelTrait)SIMPLE_DISTRIBUTION_SINGLETON));
    }

    private static class NoneSingleRel
    extends PlannerTests.TestSingleRel {
        NoneSingleRel(RelOptCluster cluster, RelNode input) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), input);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{Convention.NONE, SIMPLE_DISTRIBUTION_ANY}));
            return new NoneSingleRel(this.getCluster(), (RelNode)NoneSingleRel.sole(inputs));
        }
    }

    private static class NoneLeafRel
    extends PlannerTests.TestLeafRel {
        NoneLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), label);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (traitSet.comprises(new RelTrait[]{Convention.NONE, SIMPLE_DISTRIBUTION_ANY}));
            assert (inputs.isEmpty());
            return this;
        }
    }

    private static class ConvertRelDistributionTraitDef
    extends RelTraitDef<SimpleDistribution> {
        private ConvertRelDistributionTraitDef() {
        }

        public Class<SimpleDistribution> getTraitClass() {
            return SimpleDistribution.class;
        }

        public String toString() {
            return this.getSimpleName();
        }

        public String getSimpleName() {
            return "ConvertRelDistributionTraitDef";
        }

        public RelNode convert(RelOptPlanner planner, RelNode rel, SimpleDistribution toTrait, boolean allowInfiniteCostConverters) {
            if (toTrait == SIMPLE_DISTRIBUTION_ANY) {
                return rel;
            }
            return new BridgeRel(rel.getCluster(), rel);
        }

        public boolean canConvert(RelOptPlanner planner, SimpleDistribution fromTrait, SimpleDistribution toTrait) {
            return fromTrait == toTrait || toTrait == SIMPLE_DISTRIBUTION_ANY || fromTrait == SIMPLE_DISTRIBUTION_SINGLETON && toTrait == SIMPLE_DISTRIBUTION_RANDOM;
        }

        public SimpleDistribution getDefault() {
            return SIMPLE_DISTRIBUTION_ANY;
        }
    }

    private static class SimpleDistribution
    implements RelTrait {
        private final String name;

        SimpleDistribution(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public RelTraitDef getTraitDef() {
            return NEW_TRAIT_DEF_INSTANCE;
        }

        public boolean satisfies(RelTrait trait) {
            return trait == this || trait == SIMPLE_DISTRIBUTION_ANY;
        }

        public void register(RelOptPlanner planner) {
        }
    }

    private static class BridgeRel
    extends PlannerTests.TestSingleRel {
        BridgeRel(RelOptCluster cluster, RelNode input) {
            super(cluster, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION).plus((RelTrait)SIMPLE_DISTRIBUTION_RANDOM), input);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new BridgeRel(this.getCluster(), (RelNode)BridgeRel.sole(inputs));
        }
    }

    private static class SingletonLeafRel
    extends PlannerTests.TestLeafRel {
        SingletonLeafRel(RelOptCluster cluster, String label) {
            super(cluster, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION).plus((RelTrait)SIMPLE_DISTRIBUTION_SINGLETON), label);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new SingletonLeafRel(this.getCluster(), this.label);
        }
    }

    private static class SingleLeafTraitRule
    extends RelOptRule {
        SingleLeafTraitRule() {
            super(SingleLeafTraitRule.operand(NoneLeafRel.class, (RelOptRuleOperandChildren)SingleLeafTraitRule.any()));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneLeafRel leafRel = (NoneLeafRel)call.rel(0);
            call.transformTo((RelNode)new SingletonLeafRel(leafRel.getCluster(), leafRel.label));
        }
    }

    private static class RandomSingleRel
    extends PlannerTests.TestSingleRel {
        RandomSingleRel(RelOptCluster cluster, RelNode input) {
            super(cluster, cluster.traitSetOf((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION).plus((RelTrait)SIMPLE_DISTRIBUTION_RANDOM), input);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeTinyCost();
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new RandomSingleRel(this.getCluster(), (RelNode)RandomSingleRel.sole(inputs));
        }
    }

    private static class RandomSingleTraitRule
    extends RelOptRule {
        RandomSingleTraitRule() {
            super(RandomSingleTraitRule.operand(NoneSingleRel.class, (RelOptRuleOperandChildren)RandomSingleTraitRule.any()));
        }

        public Convention getOutConvention() {
            return PlannerTests.PHYS_CALLING_CONVENTION;
        }

        public void onMatch(RelOptRuleCall call) {
            NoneSingleRel single = (NoneSingleRel)call.rel(0);
            RelNode input = single.getInput();
            RelNode physInput = RandomSingleTraitRule.convert((RelNode)input, (RelTraitSet)single.getTraitSet().replace((RelTrait)PlannerTests.PHYS_CALLING_CONVENTION).plus((RelTrait)SIMPLE_DISTRIBUTION_RANDOM));
            call.transformTo((RelNode)new RandomSingleRel(single.getCluster(), physInput));
        }
    }
}

