/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.test.udt.util;

import com.yammer.metrics.core.Meter;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.udt.nio.NioUdtProvider;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLogger;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLoggerFactory;

public class EchoByteHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EchoByteHandler.class);
    private final ByteBuf message;
    private final Meter meter;

    public Meter meter() {
        return this.meter;
    }

    public EchoByteHandler(Meter meter, int messageSize) {
        this.meter = meter;
        this.message = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < this.message.capacity(); ++i) {
            this.message.writeByte((int)((byte)i));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active {}", (Object)NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.writeAndFlush((Object)this.message);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (this.meter != null) {
            this.meter.mark((long)buf.readableBytes());
        }
        ctx.writeAndFlush(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        log.error("exception : {}", (Object)e.getMessage());
        ctx.close();
    }
}

