/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.proxy;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelPipeline;
import org.apache.hive.druid.io.netty.channel.socket.SocketChannel;
import org.apache.hive.druid.io.netty.handler.codec.LineBasedFrameDecoder;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v4.Socks4CommandRequest;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v4.Socks4CommandStatus;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v4.Socks4CommandType;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v4.Socks4ServerDecoder;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v4.Socks4ServerEncoder;
import org.apache.hive.druid.io.netty.handler.proxy.ProxyServer;
import org.apache.hive.druid.io.netty.handler.proxy.TestMode;
import org.apache.hive.druid.io.netty.handler.proxy.UnresponsiveHandler;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.apache.hive.druid.io.netty.util.internal.SocketUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

final class Socks4ProxyServer
extends ProxyServer {
    Socks4ProxyServer(boolean useSsl, TestMode testMode, InetSocketAddress destination) {
        super(useSsl, testMode, destination);
    }

    Socks4ProxyServer(boolean useSsl, TestMode testMode, InetSocketAddress destination, String username) {
        super(useSsl, testMode, destination, username, null);
    }

    @Override
    protected void configure(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        switch (this.testMode) {
            case INTERMEDIARY: {
                p.addLast(new ChannelHandler[]{new Socks4ServerDecoder()});
                p.addLast(new ChannelHandler[]{Socks4ServerEncoder.INSTANCE});
                p.addLast(new ChannelHandler[]{new Socks4IntermediaryHandler()});
                break;
            }
            case TERMINAL: {
                p.addLast(new ChannelHandler[]{new Socks4ServerDecoder()});
                p.addLast(new ChannelHandler[]{Socks4ServerEncoder.INSTANCE});
                p.addLast(new ChannelHandler[]{new Socks4TerminalHandler()});
                break;
            }
            case UNRESPONSIVE: {
                p.addLast(new ChannelHandler[]{UnresponsiveHandler.INSTANCE});
            }
        }
    }

    private boolean authenticate(ChannelHandlerContext ctx, Socks4CommandRequest req) {
        MatcherAssert.assertThat((Object)req.type(), (Matcher)Matchers.is((Object)Socks4CommandType.CONNECT));
        if (this.testMode != TestMode.INTERMEDIARY) {
            ctx.pipeline().addBefore(ctx.name(), "lineDecoder", (ChannelHandler)new LineBasedFrameDecoder(64, false, true));
        }
        boolean authzSuccess = this.username != null ? this.username.equals(req.userId()) : true;
        return authzSuccess;
    }

    private final class Socks4TerminalHandler
    extends ProxyServer.TerminalHandler {
        private Socks4TerminalHandler() {
        }

        @Override
        protected boolean handleProxyProtocol(ChannelHandlerContext ctx, Object msg) throws Exception {
            DefaultSocks4CommandResponse res;
            Socks4CommandRequest req = (Socks4CommandRequest)msg;
            boolean authzSuccess = Socks4ProxyServer.this.authenticate(ctx, req);
            boolean sendGreeting = false;
            if (!authzSuccess) {
                res = new DefaultSocks4CommandResponse(Socks4CommandStatus.IDENTD_AUTH_FAILURE);
            } else if (!req.dstAddr().equals(Socks4ProxyServer.this.destination.getHostString()) || req.dstPort() != Socks4ProxyServer.this.destination.getPort()) {
                res = new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED);
            } else {
                res = new DefaultSocks4CommandResponse(Socks4CommandStatus.SUCCESS);
                sendGreeting = true;
            }
            ctx.write((Object)res);
            ctx.pipeline().remove(Socks4ServerDecoder.class);
            ctx.pipeline().remove(Socks4ServerEncoder.class);
            if (sendGreeting) {
                ctx.write((Object)Unpooled.copiedBuffer((CharSequence)"0\n", (Charset)CharsetUtil.US_ASCII));
            }
            return true;
        }
    }

    private final class Socks4IntermediaryHandler
    extends ProxyServer.IntermediaryHandler {
        private SocketAddress intermediaryDestination;

        private Socks4IntermediaryHandler() {
        }

        @Override
        protected boolean handleProxyProtocol(ChannelHandlerContext ctx, Object msg) throws Exception {
            DefaultSocks4CommandResponse res;
            Socks4CommandRequest req = (Socks4CommandRequest)msg;
            if (!Socks4ProxyServer.this.authenticate(ctx, req)) {
                res = new DefaultSocks4CommandResponse(Socks4CommandStatus.IDENTD_AUTH_FAILURE);
            } else {
                res = new DefaultSocks4CommandResponse(Socks4CommandStatus.SUCCESS);
                this.intermediaryDestination = SocketUtils.socketAddress((String)req.dstAddr(), (int)req.dstPort());
            }
            ctx.write((Object)res);
            ctx.pipeline().remove(Socks4ServerDecoder.class);
            ctx.pipeline().remove(Socks4ServerEncoder.class);
            return true;
        }

        @Override
        protected SocketAddress intermediaryDestination() {
            return this.intermediaryDestination;
        }
    }
}

