/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.socksx.v5;

import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5AddressType;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5CommonTestUtils;
import org.apache.hive.druid.io.netty.handler.codec.socksx.v5.Socks5Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class DefaultSocks5CommandResponseTest {
    @Test
    public void testConstructorParamsAreNotNull() {
        try {
            new DefaultSocks5CommandResponse(null, Socks5AddressType.DOMAIN);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof NullPointerException));
        }
        try {
            new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, null);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    public void testEmptyDomain() {
        DefaultSocks5CommandResponse socks5CmdResponse = new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.DOMAIN);
        Assertions.assertNull((Object)socks5CmdResponse.bndAddr());
        Assertions.assertEquals((int)0, (int)socks5CmdResponse.bndPort());
        ByteBuf buffer = Socks5CommonTestUtils.encodeServer((Socks5Message)socks5CmdResponse);
        byte[] expected = new byte[]{5, 0, 0, 3, 0, 0, 0};
        DefaultSocks5CommandResponseTest.assertByteBufEquals(expected, buffer);
        buffer.release();
    }

    @Test
    public void testIPv4Host() {
        DefaultSocks5CommandResponse socks5CmdResponse = new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "127.0.0.1", 80);
        Assertions.assertEquals((Object)"127.0.0.1", (Object)socks5CmdResponse.bndAddr());
        Assertions.assertEquals((int)80, (int)socks5CmdResponse.bndPort());
        ByteBuf buffer = Socks5CommonTestUtils.encodeServer((Socks5Message)socks5CmdResponse);
        byte[] expected = new byte[]{5, 0, 0, 1, 127, 0, 0, 1, 0, 80};
        DefaultSocks5CommandResponseTest.assertByteBufEquals(expected, buffer);
        buffer.release();
    }

    @Test
    public void testEmptyBoundAddress() {
        DefaultSocks5CommandResponse socks5CmdResponse = new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.DOMAIN, "", 80);
        Assertions.assertEquals((Object)"", (Object)socks5CmdResponse.bndAddr());
        Assertions.assertEquals((int)80, (int)socks5CmdResponse.bndPort());
        ByteBuf buffer = Socks5CommonTestUtils.encodeServer((Socks5Message)socks5CmdResponse);
        byte[] expected = new byte[]{5, 0, 0, 3, 0, 0, 80};
        DefaultSocks5CommandResponseTest.assertByteBufEquals(expected, buffer);
        buffer.release();
    }

    @Test
    public void testInvalidBoundAddress() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "127.0.0", 1000);
            }
        });
    }

    private static void assertByteBufEquals(byte[] expected, ByteBuf actual) {
        byte[] actualBytes = new byte[actual.readableBytes()];
        actual.readBytes(actualBytes);
        Assertions.assertEquals((int)expected.length, (int)actualBytes.length, (String)"Generated response has incorrect length");
        Assertions.assertArrayEquals((byte[])expected, (byte[])actualBytes, (String)"Generated response differs from expected");
    }

    @Test
    public void testValidPortRange() {
        try {
            new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "127.0.0", 0);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "127.0.0", 65536);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

