/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.socks;

import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksAddressType;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksCmdResponse;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksCmdResponseDecoder;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksCmdStatus;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksCommonTestUtils;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksMessage;
import org.apache.hive.druid.io.netty.handler.codec.socks.SocksResponse;
import org.apache.hive.druid.io.netty.handler.codec.socks.UnknownSocksResponse;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLogger;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLoggerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class SocksCmdResponseDecoderTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocksCmdResponseDecoderTest.class);

    private static void testSocksCmdResponseDecoderWithDifferentParams(SocksCmdStatus cmdStatus, SocksAddressType addressType, String host, int port) {
        logger.debug("Testing cmdStatus: " + cmdStatus + " addressType: " + addressType);
        SocksCmdResponse msg = new SocksCmdResponse(cmdStatus, addressType, host, port);
        SocksCmdResponseDecoder decoder = new SocksCmdResponseDecoder();
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{decoder});
        SocksCommonTestUtils.writeMessageIntoEmbedder(embedder, (SocksMessage)msg);
        if (addressType == SocksAddressType.UNKNOWN) {
            Assertions.assertTrue((boolean)(embedder.readInbound() instanceof UnknownSocksResponse));
        } else {
            msg = (SocksResponse)embedder.readInbound();
            Assertions.assertEquals((Object)msg.cmdStatus(), (Object)cmdStatus);
            if (host != null) {
                Assertions.assertEquals((Object)msg.host(), (Object)host);
            }
            Assertions.assertEquals((int)msg.port(), (int)port);
        }
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testSocksCmdResponseDecoder() {
        for (SocksCmdStatus cmdStatus : SocksCmdStatus.values()) {
            for (SocksAddressType addressType : SocksAddressType.values()) {
                SocksCmdResponseDecoderTest.testSocksCmdResponseDecoderWithDifferentParams(cmdStatus, addressType, null, 0);
            }
        }
    }

    @Test
    public void testInvalidAddress() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                SocksCmdResponseDecoderTest.testSocksCmdResponseDecoderWithDifferentParams(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "1", 80);
            }
        });
    }

    @Test
    public void testSocksCmdResponseDecoderIncludingHost() {
        for (SocksCmdStatus cmdStatus : SocksCmdStatus.values()) {
            SocksCmdResponseDecoderTest.testSocksCmdResponseDecoderWithDifferentParams(cmdStatus, SocksAddressType.IPv4, "127.0.0.1", 80);
            SocksCmdResponseDecoderTest.testSocksCmdResponseDecoderWithDifferentParams(cmdStatus, SocksAddressType.DOMAIN, "testDomain.com", 80);
            SocksCmdResponseDecoderTest.testSocksCmdResponseDecoderWithDifferentParams(cmdStatus, SocksAddressType.IPv6, "2001:db8:85a3:42:1000:8a2e:370:7334", 80);
            SocksCmdResponseDecoderTest.testSocksCmdResponseDecoderWithDifferentParams(cmdStatus, SocksAddressType.IPv6, "1111:111:11:1:0:0:0:1", 80);
        }
    }
}

