/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.smtp;

import java.nio.charset.Charset;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.EncoderException;
import org.apache.hive.druid.io.netty.handler.codec.smtp.DefaultLastSmtpContent;
import org.apache.hive.druid.io.netty.handler.codec.smtp.DefaultSmtpContent;
import org.apache.hive.druid.io.netty.handler.codec.smtp.SmtpRequest;
import org.apache.hive.druid.io.netty.handler.codec.smtp.SmtpRequestEncoder;
import org.apache.hive.druid.io.netty.handler.codec.smtp.SmtpRequests;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class SmtpRequestEncoderTest {
    @Test
    public void testEncodeEhlo() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.ehlo((CharSequence)"localhost"), "EHLO localhost\r\n");
    }

    @Test
    public void testEncodeHelo() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.helo((CharSequence)"localhost"), "HELO localhost\r\n");
    }

    @Test
    public void testEncodeAuth() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.auth((CharSequence[])new CharSequence[]{"LOGIN"}), "AUTH LOGIN\r\n");
    }

    @Test
    public void testEncodeAuthWithParameter() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.auth((CharSequence[])new CharSequence[]{"PLAIN", "dGVzdAB0ZXN0ADEyMzQ="}), "AUTH PLAIN dGVzdAB0ZXN0ADEyMzQ=\r\n");
    }

    @Test
    public void testEncodeEmpty() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.empty((CharSequence[])new CharSequence[]{"dGVzdAB0ZXN0ADEyMzQ="}), "dGVzdAB0ZXN0ADEyMzQ=\r\n");
    }

    @Test
    public void testEncodeMail() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.mail((CharSequence)"me@netty.io", (CharSequence[])new CharSequence[0]), "MAIL FROM:<me@netty.io>\r\n");
    }

    @Test
    public void testEncodeMailNullSender() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.mail(null, (CharSequence[])new CharSequence[0]), "MAIL FROM:<>\r\n");
    }

    @Test
    public void testEncodeRcpt() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.rcpt((CharSequence)"me@netty.io", (CharSequence[])new CharSequence[0]), "RCPT TO:<me@netty.io>\r\n");
    }

    @Test
    public void testEncodeNoop() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.noop(), "NOOP\r\n");
    }

    @Test
    public void testEncodeRset() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.rset(), "RSET\r\n");
    }

    @Test
    public void testEncodeHelp() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.help(null), "HELP\r\n");
    }

    @Test
    public void testEncodeHelpWithArg() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.help((String)"MAIL"), "HELP MAIL\r\n");
    }

    @Test
    public void testEncodeData() {
        SmtpRequestEncoderTest.testEncode(SmtpRequests.data(), "DATA\r\n");
    }

    @Test
    public void testEncodeDataAndContent() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SmtpRequestEncoder()});
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.data()}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultSmtpContent(Unpooled.copiedBuffer((CharSequence)"Subject: Test\r\n\r\n", (Charset)CharsetUtil.US_ASCII))}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultLastSmtpContent(Unpooled.copiedBuffer((CharSequence)"Test\r\n", (Charset)CharsetUtil.US_ASCII))}));
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertEquals((Object)"DATA\r\nSubject: Test\r\n\r\nTest\r\n.\r\n", (Object)SmtpRequestEncoderTest.getWrittenString(channel));
    }

    @Test
    public void testThrowsIfContentExpected() {
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SmtpRequestEncoder()});
        try {
            Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.data()}));
            Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

                public void execute() {
                    channel.writeOutbound(new Object[]{SmtpRequests.noop()});
                }
            });
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    @Test
    public void testRsetClearsContentExpectedFlag() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SmtpRequestEncoder()});
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.data()}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.rset()}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{SmtpRequests.noop()}));
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertEquals((Object)"DATA\r\nRSET\r\nNOOP\r\n", (Object)SmtpRequestEncoderTest.getWrittenString(channel));
    }

    private static String getWrittenString(EmbeddedChannel channel) {
        ByteBuf buffer;
        ByteBuf written = Unpooled.buffer();
        while ((buffer = (ByteBuf)channel.readOutbound()) != null) {
            written.writeBytes(buffer);
            buffer.release();
        }
        String writtenString = written.toString(CharsetUtil.US_ASCII);
        written.release();
        return writtenString;
    }

    private static void testEncode(SmtpRequest request, String expected) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SmtpRequestEncoder()});
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{request}));
        Assertions.assertTrue((boolean)channel.finish());
        ByteBuf buffer = (ByteBuf)channel.readOutbound();
        Assertions.assertEquals((Object)expected, (Object)buffer.toString(CharsetUtil.US_ASCII));
        buffer.release();
        Assertions.assertNull((Object)channel.readOutbound());
    }
}

