/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.util.ArrayList;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelConfig;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelMetadata;
import org.apache.hive.druid.io.netty.channel.ChannelPromise;
import org.apache.hive.druid.io.netty.channel.DefaultChannelPromise;
import org.apache.hive.druid.io.netty.channel.DefaultMessageSizeEstimator;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Error;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameListener;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameReader;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameSizePolicy;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameWriter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2RemoteFlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Settings;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Stream;
import org.apache.hive.druid.io.netty.handler.codec.http2.StreamBufferingEncoder;
import org.apache.hive.druid.io.netty.util.ReferenceCountUtil;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;
import org.apache.hive.druid.io.netty.util.concurrent.ImmediateEventExecutor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class StreamBufferingEncoderTest {
    private StreamBufferingEncoder encoder;
    private Http2Connection connection;
    @Mock
    private Http2FrameWriter writer;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private Channel channel;
    @Mock
    private Channel.Unsafe unsafe;
    @Mock
    private ChannelConfig config;
    @Mock
    private EventExecutor executor;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Http2FrameWriter.Configuration configuration = (Http2FrameWriter.Configuration)Mockito.mock(Http2FrameWriter.Configuration.class);
        Http2FrameSizePolicy frameSizePolicy = (Http2FrameSizePolicy)Mockito.mock(Http2FrameSizePolicy.class);
        Mockito.when((Object)this.writer.configuration()).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.frameSizePolicy()).thenReturn((Object)frameSizePolicy);
        Mockito.when((Object)frameSizePolicy.maxFrameSize()).thenReturn((Object)16384);
        Mockito.when((Object)this.writer.writeData((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer(this.successAnswer());
        Mockito.when((Object)this.writer.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.anyInt(), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer(this.successAnswer());
        Mockito.when((Object)this.writer.writeGoAway((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer(this.successAnswer());
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer(this.noopAnswer());
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer(this.noopAnswer());
        this.connection = new DefaultHttp2Connection(false);
        this.connection.remote().flowController((Http2FlowController)new DefaultHttp2RemoteFlowController(this.connection));
        this.connection.local().flowController((Http2FlowController)new DefaultHttp2LocalFlowController(this.connection).frameWriter(this.writer));
        DefaultHttp2ConnectionEncoder defaultEncoder = new DefaultHttp2ConnectionEncoder(this.connection, this.writer);
        this.encoder = new StreamBufferingEncoder((Http2ConnectionEncoder)defaultEncoder);
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(this.connection, (Http2ConnectionEncoder)this.encoder, (Http2FrameReader)Mockito.mock(Http2FrameReader.class));
        Http2ConnectionHandler handler = new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)Mockito.mock(Http2FrameListener.class)).codec((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)this.encoder).build();
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.channel.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.executor.inEventLoop()).thenReturn((Object)true);
        ((ChannelHandlerContext)Mockito.doAnswer((Answer)new Answer<ChannelPromise>(){

            public ChannelPromise answer(InvocationOnMock invocation) throws Throwable {
                return StreamBufferingEncoderTest.this.newPromise();
            }
        }).when((Object)this.ctx)).newPromise();
        Mockito.when((Object)this.ctx.executor()).thenReturn((Object)this.executor);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)false);
        Mockito.when((Object)this.channel.config()).thenReturn((Object)this.config);
        Mockito.when((Object)this.channel.isWritable()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.bytesBeforeUnwritable()).thenReturn((Object)Long.MAX_VALUE);
        Mockito.when((Object)this.config.getWriteBufferHighWaterMark()).thenReturn((Object)Integer.MAX_VALUE);
        Mockito.when((Object)this.config.getMessageSizeEstimator()).thenReturn((Object)DefaultMessageSizeEstimator.DEFAULT);
        ChannelMetadata metadata = new ChannelMetadata(false, 16);
        Mockito.when((Object)this.channel.metadata()).thenReturn((Object)metadata);
        Mockito.when((Object)this.channel.unsafe()).thenReturn((Object)this.unsafe);
        handler.handlerAdded(this.ctx);
    }

    @AfterEach
    public void teardown() {
        this.encoder.close();
    }

    @Test
    public void multipleWritesToActiveStream() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        ByteBuf data = StreamBufferingEncoderTest.data();
        int expectedBytes = data.readableBytes() * 3;
        this.encoder.writeData(this.ctx, 3, data, 0, false, this.newPromise());
        this.encoder.writeData(this.ctx, 3, StreamBufferingEncoderTest.data(), 0, false, this.newPromise());
        this.encoder.writeData(this.ctx, 3, StreamBufferingEncoderTest.data(), 0, false, this.newPromise());
        this.encoderWriteHeaders(3, this.newPromise());
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 3);
        ArgumentCaptor bufCaptor = ArgumentCaptor.forClass(ByteBuf.class);
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeData((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), (ByteBuf)bufCaptor.capture(), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.any(ChannelPromise.class));
        Assertions.assertEquals((int)expectedBytes, (int)((ByteBuf)bufCaptor.getValue()).readableBytes());
    }

    @Test
    public void ensureCanCreateNextStreamWhenStreamCloses() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(1);
        this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        this.encoderWriteHeaders(5, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        this.setMaxConcurrentStreams(0);
        this.connection.stream(3).close();
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 3);
        this.writeVerifyWriteHeaders(Mockito.never(), 5);
        Assertions.assertEquals((int)0, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
    }

    @Test
    public void alternatingWritesToActiveAndBufferedStreams() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(1);
        this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        this.encoderWriteHeaders(5, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        this.encoder.writeData(this.ctx, 3, Unpooled.EMPTY_BUFFER, 0, false, this.newPromise());
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 3);
        this.encoder.writeData(this.ctx, 5, Unpooled.EMPTY_BUFFER, 0, false, this.newPromise());
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.never())).writeData((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)5), (ByteBuf)Mockito.any(ByteBuf.class), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.eq((Object)this.newPromise()));
    }

    @Test
    public void bufferingNewStreamFailsAfterGoAwayReceived() throws Http2Exception {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(0);
        this.connection.goAwayReceived(1, 8L, Unpooled.EMPTY_BUFFER);
        ChannelPromise promise = this.newPromise();
        this.encoderWriteHeaders(3, promise);
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
    }

    @Test
    public void receivingGoAwayFailsBufferedStreams() throws Http2Exception {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(5);
        int streamId = 3;
        ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
        for (int i = 0; i < 9; ++i) {
            futures.add(this.encoderWriteHeaders(streamId, this.newPromise()));
            streamId += 2;
        }
        Assertions.assertEquals((int)5, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)4, (int)this.encoder.numBufferedStreams());
        this.connection.goAwayReceived(11, 8L, Unpooled.EMPTY_BUFFER);
        Assertions.assertEquals((int)5, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        int failCount = 0;
        for (ChannelFuture f : futures) {
            if (f.cause() == null) continue;
            Assertions.assertTrue((boolean)(f.cause() instanceof StreamBufferingEncoder.Http2GoAwayException));
            ++failCount;
        }
        Assertions.assertEquals((int)4, (int)failCount);
    }

    @Test
    public void receivingGoAwayFailsNewStreamIfMaxConcurrentStreamsReached() throws Http2Exception {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(1);
        this.encoderWriteHeaders(3, this.newPromise());
        this.connection.goAwayReceived(11, 8L, Unpooled.EMPTY_BUFFER);
        ChannelFuture f = this.encoderWriteHeaders(5, this.newPromise());
        Assertions.assertTrue((boolean)(f.cause() instanceof StreamBufferingEncoder.Http2GoAwayException));
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
    }

    @Test
    public void sendingGoAwayShouldNotFailStreams() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(1);
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer(this.successAnswer());
        Mockito.when((Object)this.writer.writeHeaders((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.anyInt(), Mockito.anyShort(), Mockito.anyBoolean(), Mockito.anyInt(), Mockito.anyBoolean(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer(this.successAnswer());
        ChannelFuture f1 = this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        ChannelFuture f2 = this.encoderWriteHeaders(5, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        ChannelFuture f3 = this.encoderWriteHeaders(7, this.newPromise());
        Assertions.assertEquals((int)2, (int)this.encoder.numBufferedStreams());
        ByteBuf empty = Unpooled.buffer((int)0);
        this.encoder.writeGoAway(this.ctx, 3, Http2Error.CANCEL.code(), empty, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)2, (int)this.encoder.numBufferedStreams());
        Assertions.assertFalse((boolean)f1.isDone());
        Assertions.assertFalse((boolean)f2.isDone());
        Assertions.assertFalse((boolean)f3.isDone());
    }

    @Test
    public void endStreamDoesNotFailBufferedStream() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(0);
        this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        this.encoder.writeData(this.ctx, 3, Unpooled.EMPTY_BUFFER, 0, true, this.newPromise());
        Assertions.assertEquals((int)0, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        this.setMaxConcurrentStreams(1);
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_LOCAL, (Object)this.connection.stream(3).state());
    }

    @Test
    public void rstStreamClosesBufferedStream() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(0);
        this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        ChannelPromise rstStreamPromise = this.newPromise();
        this.encoder.writeRstStream(this.ctx, 3, Http2Error.CANCEL.code(), rstStreamPromise);
        Assertions.assertTrue((boolean)rstStreamPromise.isSuccess());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
    }

    @Test
    public void bufferUntilActiveStreamsAreReset() throws Exception {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(1);
        this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        this.encoderWriteHeaders(5, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        this.encoderWriteHeaders(7, this.newPromise());
        Assertions.assertEquals((int)2, (int)this.encoder.numBufferedStreams());
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 3);
        this.writeVerifyWriteHeaders(Mockito.never(), 5);
        this.writeVerifyWriteHeaders(Mockito.never(), 7);
        this.encoder.writeRstStream(this.ctx, 3, Http2Error.CANCEL.code(), this.newPromise());
        ((Http2RemoteFlowController)this.connection.remote().flowController()).writePendingBytes();
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 5);
        this.writeVerifyWriteHeaders(Mockito.never(), 7);
        Assertions.assertEquals((int)1, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        this.encoder.writeRstStream(this.ctx, 5, Http2Error.CANCEL.code(), this.newPromise());
        ((Http2RemoteFlowController)this.connection.remote().flowController()).writePendingBytes();
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 7);
        Assertions.assertEquals((int)1, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        this.encoder.writeRstStream(this.ctx, 7, Http2Error.CANCEL.code(), this.newPromise());
        Assertions.assertEquals((int)0, (int)this.connection.numActiveStreams());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
    }

    @Test
    public void bufferUntilMaxStreamsIncreased() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(2);
        this.encoderWriteHeaders(3, this.newPromise());
        this.encoderWriteHeaders(5, this.newPromise());
        this.encoderWriteHeaders(7, this.newPromise());
        this.encoderWriteHeaders(9, this.newPromise());
        Assertions.assertEquals((int)2, (int)this.encoder.numBufferedStreams());
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 3);
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 5);
        this.writeVerifyWriteHeaders(Mockito.never(), 7);
        this.writeVerifyWriteHeaders(Mockito.never(), 9);
        this.setMaxConcurrentStreams(5);
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 7);
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 9);
        this.encoderWriteHeaders(11, this.newPromise());
        this.writeVerifyWriteHeaders(Mockito.times((int)1), 11);
        Assertions.assertEquals((int)5, (int)this.connection.local().numActiveStreams());
    }

    @Test
    public void bufferUntilSettingsReceived() throws Http2Exception {
        int initialLimit = 100;
        int numStreams = initialLimit * 2;
        int ix = 0;
        int nextStreamId = 3;
        while (ix < numStreams) {
            this.encoderWriteHeaders(nextStreamId, this.newPromise());
            if (ix < initialLimit) {
                this.writeVerifyWriteHeaders(Mockito.times((int)1), nextStreamId);
            } else {
                this.writeVerifyWriteHeaders(Mockito.never(), nextStreamId);
            }
            ++ix;
            nextStreamId += 2;
        }
        Assertions.assertEquals((int)(numStreams / 2), (int)this.encoder.numBufferedStreams());
        this.setMaxConcurrentStreams(initialLimit * 2);
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        Assertions.assertEquals((int)numStreams, (int)this.connection.local().numActiveStreams());
    }

    @Test
    public void bufferUntilSettingsReceivedWithNoMaxConcurrentStreamValue() throws Http2Exception {
        int initialLimit = 100;
        int numStreams = initialLimit * 2;
        int ix = 0;
        int nextStreamId = 3;
        while (ix < numStreams) {
            this.encoderWriteHeaders(nextStreamId, this.newPromise());
            if (ix < initialLimit) {
                this.writeVerifyWriteHeaders(Mockito.times((int)1), nextStreamId);
            } else {
                this.writeVerifyWriteHeaders(Mockito.never(), nextStreamId);
            }
            ++ix;
            nextStreamId += 2;
        }
        Assertions.assertEquals((int)(numStreams / 2), (int)this.encoder.numBufferedStreams());
        this.encoder.remoteSettings(new Http2Settings());
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        Assertions.assertEquals((int)numStreams, (int)this.connection.local().numActiveStreams());
    }

    @Test
    public void exhaustedStreamsDoNotBuffer() throws Http2Exception {
        this.encoderWriteHeaders(Integer.MAX_VALUE, this.newPromise());
        this.setMaxConcurrentStreams(0);
        ChannelFuture f = this.encoderWriteHeaders(-1, this.newPromise());
        Assertions.assertNotNull((Object)f.cause());
    }

    @Test
    public void closedBufferedStreamReleasesByteBuf() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.setMaxConcurrentStreams(0);
        ByteBuf data = (ByteBuf)Mockito.mock(ByteBuf.class);
        ChannelFuture f1 = this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertEquals((int)1, (int)this.encoder.numBufferedStreams());
        ChannelFuture f2 = this.encoder.writeData(this.ctx, 3, data, 0, false, this.newPromise());
        ChannelPromise rstPromise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        this.encoder.writeRstStream(this.ctx, 3, Http2Error.CANCEL.code(), rstPromise);
        Assertions.assertEquals((int)0, (int)this.encoder.numBufferedStreams());
        ((ChannelPromise)Mockito.verify((Object)rstPromise)).setSuccess();
        Assertions.assertTrue((boolean)f1.isSuccess());
        Assertions.assertTrue((boolean)f2.isSuccess());
        ((ByteBuf)Mockito.verify((Object)data)).release();
    }

    @Test
    public void closeShouldCancelAllBufferedStreams() throws Http2Exception {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.connection.local().maxActiveStreams(0);
        ChannelFuture f1 = this.encoderWriteHeaders(3, this.newPromise());
        ChannelFuture f2 = this.encoderWriteHeaders(5, this.newPromise());
        ChannelFuture f3 = this.encoderWriteHeaders(7, this.newPromise());
        this.encoder.close();
        Assertions.assertNotNull((Object)f1.cause());
        Assertions.assertNotNull((Object)f2.cause());
        Assertions.assertNotNull((Object)f3.cause());
    }

    @Test
    public void headersAfterCloseShouldImmediatelyFail() {
        this.encoder.writeSettingsAck(this.ctx, this.newPromise());
        this.encoder.close();
        ChannelFuture f = this.encoderWriteHeaders(3, this.newPromise());
        Assertions.assertNotNull((Object)f.cause());
    }

    private void setMaxConcurrentStreams(int newValue) {
        try {
            this.encoder.remoteSettings(new Http2Settings().maxConcurrentStreams((long)newValue));
            this.encoder.flowController().writePendingBytes();
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ChannelFuture encoderWriteHeaders(int streamId, ChannelPromise promise) {
        this.encoder.writeHeaders(this.ctx, streamId, (Http2Headers)new DefaultHttp2Headers(), 0, (short)16, false, 0, false, promise);
        try {
            this.encoder.flowController().writePendingBytes();
            return promise;
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeVerifyWriteHeaders(VerificationMode mode, int streamId) {
        ((Http2FrameWriter)Mockito.verify((Object)this.writer, (VerificationMode)mode)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)streamId), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.eq((int)0), Mockito.eq((short)16), Mockito.eq((boolean)false), Mockito.eq((int)0), Mockito.eq((boolean)false), (ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    private Answer<ChannelFuture> successAnswer() {
        return new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocation) throws Throwable {
                for (Object a : invocation.getArguments()) {
                    ReferenceCountUtil.safeRelease((Object)a);
                }
                ChannelPromise future = StreamBufferingEncoderTest.this.newPromise();
                future.setSuccess();
                return future;
            }
        };
    }

    private Answer<ChannelFuture> noopAnswer() {
        return new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocation) throws Throwable {
                for (Object a : invocation.getArguments()) {
                    if (!(a instanceof ChannelPromise)) continue;
                    return (ChannelFuture)a;
                }
                return StreamBufferingEncoderTest.this.newPromise();
            }
        };
    }

    private ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
    }

    private static ByteBuf data() {
        ByteBuf buf = Unpooled.buffer((int)10);
        for (int i = 0; i < buf.writableBytes(); ++i) {
            buf.writeByte(i);
        }
        return buf;
    }
}

