/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import javax.net.ssl.SSLException;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodec;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameWriter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2MultiplexActiveStreamsException;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2MultiplexHandler;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2MultiplexTest;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2StreamChannel;
import org.apache.hive.druid.io.netty.handler.codec.http2.LastInboundHandler;
import org.apache.hive.druid.io.netty.handler.codec.http2.TestChannelInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class Http2MultiplexHandlerTest
extends Http2MultiplexTest<Http2FrameCodec> {
    @Override
    protected Http2FrameCodec newCodec(TestChannelInitializer childChannelInitializer, Http2FrameWriter frameWriter) {
        return new Http2FrameCodecBuilder(true).frameWriter(frameWriter).build();
    }

    @Override
    protected ChannelHandler newMultiplexer(TestChannelInitializer childChannelInitializer) {
        return new Http2MultiplexHandler((ChannelHandler)childChannelInitializer, null);
    }

    @Override
    protected boolean useUserEventForResetFrame() {
        return true;
    }

    @Override
    protected boolean ignoreWindowUpdateFrames() {
        return true;
    }

    @Test
    public void sslExceptionTriggersChildChannelException() {
        final LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)channel.isActive());
        final RuntimeException testExc = new RuntimeException(new SSLException("foo"));
        channel.parent().pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (cause != testExc) {
                    super.exceptionCaught(ctx, cause);
                }
            }
        }});
        channel.parent().pipeline().fireExceptionCaught((Throwable)testExc);
        Assertions.assertTrue((boolean)channel.isActive());
        RuntimeException exc = (RuntimeException)Assertions.assertThrows(RuntimeException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                inboundHandler.checkException();
            }
        });
        Assertions.assertEquals((Object)testExc, (Object)exc);
    }

    @Test
    public void customExceptionForwarding() {
        final LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)channel.isActive());
        final RuntimeException testExc = new RuntimeException("xyz");
        channel.parent().pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (cause != testExc) {
                    super.exceptionCaught(ctx, cause);
                } else {
                    ctx.pipeline().fireExceptionCaught((Throwable)new Http2MultiplexActiveStreamsException(cause));
                }
            }
        }});
        channel.parent().pipeline().fireExceptionCaught((Throwable)testExc);
        Assertions.assertTrue((boolean)channel.isActive());
        RuntimeException exc = (RuntimeException)Assertions.assertThrows(RuntimeException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                inboundHandler.checkException();
            }
        });
        Assertions.assertEquals((Object)testExc, (Object)exc);
    }
}

