/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.net.SocketAddress;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.ByteBufAllocator;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.ChannelPipeline;
import org.apache.hive.druid.io.netty.channel.ChannelProgressivePromise;
import org.apache.hive.druid.io.netty.channel.ChannelPromise;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Flags;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameWriter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Settings;
import org.apache.hive.druid.io.netty.util.Attribute;
import org.apache.hive.druid.io.netty.util.AttributeKey;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;

final class Http2FrameInboundWriter {
    private final ChannelHandlerContext ctx;
    private final Http2FrameWriter writer;

    Http2FrameInboundWriter(EmbeddedChannel channel) {
        this(channel, (Http2FrameWriter)new DefaultHttp2FrameWriter());
    }

    Http2FrameInboundWriter(EmbeddedChannel channel, Http2FrameWriter writer) {
        this.ctx = new WriteInboundChannelHandlerContext(channel);
        this.writer = writer;
    }

    void writeInboundData(int streamId, ByteBuf data, int padding, boolean endStream) {
        this.writer.writeData(this.ctx, streamId, data, padding, endStream, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundHeaders(int streamId, Http2Headers headers, int padding, boolean endStream) {
        this.writer.writeHeaders(this.ctx, streamId, headers, padding, endStream, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundHeaders(int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
        this.writer.writeHeaders(this.ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundPriority(int streamId, int streamDependency, short weight, boolean exclusive) {
        this.writer.writePriority(this.ctx, streamId, streamDependency, weight, exclusive, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundRstStream(int streamId, long errorCode) {
        this.writer.writeRstStream(this.ctx, streamId, errorCode, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundSettings(Http2Settings settings) {
        this.writer.writeSettings(this.ctx, settings, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundSettingsAck() {
        this.writer.writeSettingsAck(this.ctx, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundPing(boolean ack, long data) {
        this.writer.writePing(this.ctx, ack, data, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writePushPromise(int streamId, int promisedStreamId, Http2Headers headers, int padding) {
        this.writer.writePushPromise(this.ctx, streamId, promisedStreamId, headers, padding, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundGoAway(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.writer.writeGoAway(this.ctx, lastStreamId, errorCode, debugData, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundWindowUpdate(int streamId, int windowSizeIncrement) {
        this.writer.writeWindowUpdate(this.ctx, streamId, windowSizeIncrement, this.ctx.newPromise()).syncUninterruptibly();
    }

    void writeInboundFrame(byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
        this.writer.writeFrame(this.ctx, frameType, streamId, flags, payload, this.ctx.newPromise()).syncUninterruptibly();
    }

    private static final class WriteInboundChannelHandlerContext
    extends ChannelOutboundHandlerAdapter
    implements ChannelHandlerContext {
        private final EmbeddedChannel channel;

        WriteInboundChannelHandlerContext(EmbeddedChannel channel) {
            this.channel = channel;
        }

        public Channel channel() {
            return this.channel;
        }

        public EventExecutor executor() {
            return this.channel.eventLoop();
        }

        public String name() {
            return "WriteInbound";
        }

        public ChannelHandler handler() {
            return this;
        }

        public boolean isRemoved() {
            return false;
        }

        public ChannelHandlerContext fireChannelRegistered() {
            this.channel.pipeline().fireChannelRegistered();
            return this;
        }

        public ChannelHandlerContext fireChannelUnregistered() {
            this.channel.pipeline().fireChannelUnregistered();
            return this;
        }

        public ChannelHandlerContext fireChannelActive() {
            this.channel.pipeline().fireChannelActive();
            return this;
        }

        public ChannelHandlerContext fireChannelInactive() {
            this.channel.pipeline().fireChannelInactive();
            return this;
        }

        public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
            this.channel.pipeline().fireExceptionCaught(cause);
            return this;
        }

        public ChannelHandlerContext fireUserEventTriggered(Object evt) {
            this.channel.pipeline().fireUserEventTriggered(evt);
            return this;
        }

        public ChannelHandlerContext fireChannelRead(Object msg) {
            this.channel.pipeline().fireChannelRead(msg);
            return this;
        }

        public ChannelHandlerContext fireChannelReadComplete() {
            this.channel.pipeline().fireChannelReadComplete();
            return this;
        }

        public ChannelHandlerContext fireChannelWritabilityChanged() {
            this.channel.pipeline().fireChannelWritabilityChanged();
            return this;
        }

        public ChannelHandlerContext read() {
            this.channel.read();
            return this;
        }

        public ChannelHandlerContext flush() {
            this.channel.pipeline().fireChannelReadComplete();
            return this;
        }

        public ChannelPipeline pipeline() {
            return this.channel.pipeline();
        }

        public ByteBufAllocator alloc() {
            return this.channel.alloc();
        }

        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return this.channel.attr(key);
        }

        public <T> boolean hasAttr(AttributeKey<T> key) {
            return this.channel.hasAttr(key);
        }

        public ChannelFuture bind(SocketAddress localAddress) {
            return this.channel.bind(localAddress);
        }

        public ChannelFuture connect(SocketAddress remoteAddress) {
            return this.channel.connect(remoteAddress);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
            return this.channel.connect(remoteAddress, localAddress);
        }

        public ChannelFuture disconnect() {
            return this.channel.disconnect();
        }

        public ChannelFuture close() {
            return this.channel.close();
        }

        public ChannelFuture deregister() {
            return this.channel.deregister();
        }

        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
            return this.channel.bind(localAddress, promise);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
            return this.channel.connect(remoteAddress, promise);
        }

        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            return this.channel.connect(remoteAddress, localAddress, promise);
        }

        public ChannelFuture disconnect(ChannelPromise promise) {
            return this.channel.disconnect(promise);
        }

        public ChannelFuture close(ChannelPromise promise) {
            return this.channel.close(promise);
        }

        public ChannelFuture deregister(ChannelPromise promise) {
            return this.channel.deregister(promise);
        }

        public ChannelFuture write(Object msg) {
            return this.write(msg, this.newPromise());
        }

        public ChannelFuture write(Object msg, ChannelPromise promise) {
            return this.writeAndFlush(msg, promise);
        }

        public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
            try {
                this.channel.writeInbound(new Object[]{msg});
                this.channel.runPendingTasks();
                promise.setSuccess();
            }
            catch (Throwable cause) {
                promise.setFailure(cause);
            }
            return promise;
        }

        public ChannelFuture writeAndFlush(Object msg) {
            return this.writeAndFlush(msg, this.newPromise());
        }

        public ChannelPromise newPromise() {
            return this.channel.newPromise();
        }

        public ChannelProgressivePromise newProgressivePromise() {
            return this.channel.newProgressivePromise();
        }

        public ChannelFuture newSucceededFuture() {
            return this.channel.newSucceededFuture();
        }

        public ChannelFuture newFailedFuture(Throwable cause) {
            return this.channel.newFailedFuture(cause);
        }

        public ChannelPromise voidPromise() {
            return this.channel.voidPromise();
        }
    }
}

