/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelFutureListener;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.ChannelPromise;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.UnsupportedMessageTypeException;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.hive.druid.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpScheme;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpServerUpgradeHandler;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpVersion;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2PriorityFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2UnknownFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2DataFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Error;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Flags;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Frame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodec;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameInboundWriter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameLogger;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameReader;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameStream;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameStreamEvent;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameStreamException;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameWriter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2GoAwayFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2HeadersFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2LocalFlowController;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2PingFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ResetFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Settings;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2SettingsAckFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2SettingsFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Stream;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2StreamFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2TestUtil;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import org.apache.hive.druid.io.netty.handler.codec.http2.LastInboundHandler;
import org.apache.hive.druid.io.netty.handler.logging.LogLevel;
import org.apache.hive.druid.io.netty.util.AbstractReferenceCounted;
import org.apache.hive.druid.io.netty.util.AsciiString;
import org.apache.hive.druid.io.netty.util.ReferenceCountUtil;
import org.apache.hive.druid.io.netty.util.ReferenceCounted;
import org.apache.hive.druid.io.netty.util.concurrent.DefaultPromise;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;
import org.apache.hive.druid.io.netty.util.concurrent.GenericFutureListener;
import org.apache.hive.druid.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.hive.druid.io.netty.util.concurrent.Promise;
import org.apache.hive.druid.io.netty.util.internal.ReflectionUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class Http2FrameCodecTest {
    private Http2FrameWriter frameWriter;
    private Http2FrameCodec frameCodec;
    private EmbeddedChannel channel;
    private Http2FrameInboundWriter frameInboundWriter;
    private LastInboundHandler inboundHandler;
    private final Http2Headers request = new DefaultHttp2Headers().method((CharSequence)HttpMethod.GET.asciiName()).scheme((CharSequence)HttpScheme.HTTPS.name()).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/foo"));
    private final Http2Headers response = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText());

    @BeforeEach
    public void setUp() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer(), new Http2Settings());
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.inboundHandler != null) {
            this.inboundHandler.finishAndReleaseAll();
            this.inboundHandler = null;
        }
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
            this.channel.close();
            this.channel = null;
        }
    }

    private void setUp(Http2FrameCodecBuilder frameCodecBuilder, Http2Settings initialRemoteSettings) throws Exception {
        this.tearDown();
        this.frameWriter = Http2TestUtil.mockedFrameWriter();
        this.frameCodec = frameCodecBuilder.frameWriter(this.frameWriter).frameLogger(new Http2FrameLogger(LogLevel.TRACE)).initialSettings(initialRemoteSettings).build();
        this.inboundHandler = new LastInboundHandler();
        this.channel = new EmbeddedChannel();
        this.frameInboundWriter = new Http2FrameInboundWriter(this.channel);
        this.channel.connect((SocketAddress)new InetSocketAddress(0));
        this.channel.pipeline().addLast(new ChannelHandler[]{this.frameCodec});
        this.channel.pipeline().addLast(new ChannelHandler[]{this.inboundHandler});
        this.channel.pipeline().fireChannelActive();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettings(this.eqFrameCodecCtx(), Http2TestUtil.anyHttp2Settings(), Http2TestUtil.anyChannelPromise());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.frameWriter});
        this.channel.writeInbound(new Object[]{Http2CodecUtil.connectionPrefaceBuf()});
        this.frameInboundWriter.writeInboundSettings(initialRemoteSettings);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettingsAck(this.eqFrameCodecCtx(), Http2TestUtil.anyChannelPromise());
        this.frameInboundWriter.writeInboundSettingsAck();
        Http2SettingsFrame settingsFrame = (Http2SettingsFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)settingsFrame);
        Http2SettingsAckFrame settingsAckFrame = (Http2SettingsAckFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)settingsAckFrame);
    }

    @Test
    public void stateChanges() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 31, true);
        Http2Stream stream = this.frameCodec.connection().stream(1);
        Assertions.assertNotNull((Object)stream);
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Http2FrameStreamEvent event = (Http2FrameStreamEvent)this.inboundHandler.readInboundMessageOrUserEvent();
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)event.stream().state());
        Http2StreamFrame inboundFrame = (Http2StreamFrame)this.inboundHandler.readInbound();
        Http2FrameStream stream2 = inboundFrame.stream();
        Assertions.assertNotNull((Object)stream2);
        Assertions.assertEquals((int)1, (int)stream2.id());
        Assertions.assertEquals((Object)inboundFrame, (Object)new DefaultHttp2HeadersFrame(this.request, true, 31).stream(stream2));
        Assertions.assertNull(this.inboundHandler.readInbound());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2HeadersFrame(this.response, true, 27).stream(stream2)});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeHeaders(this.eqFrameCodecCtx(), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)this.response), Mockito.eq((int)27), Mockito.eq((boolean)true), Http2TestUtil.anyChannelPromise());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqFrameCodecCtx(), Mockito.anyInt(), Mockito.anyLong(), Http2TestUtil.anyChannelPromise());
        Assertions.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        event = (Http2FrameStreamEvent)this.inboundHandler.readInboundMessageOrUserEvent();
        Assertions.assertEquals((Object)Http2Stream.State.CLOSED, (Object)event.stream().state());
        Assertions.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void headerRequestHeaderResponse() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 31, true);
        Http2Stream stream = this.frameCodec.connection().stream(1);
        Assertions.assertNotNull((Object)stream);
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Http2StreamFrame inboundFrame = (Http2StreamFrame)this.inboundHandler.readInbound();
        Http2FrameStream stream2 = inboundFrame.stream();
        Assertions.assertNotNull((Object)stream2);
        Assertions.assertEquals((int)1, (int)stream2.id());
        Assertions.assertEquals((Object)inboundFrame, (Object)new DefaultHttp2HeadersFrame(this.request, true, 31).stream(stream2));
        Assertions.assertNull(this.inboundHandler.readInbound());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2HeadersFrame(this.response, true, 27).stream(stream2)});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeHeaders(this.eqFrameCodecCtx(), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)this.response), Mockito.eq((int)27), Mockito.eq((boolean)true), Http2TestUtil.anyChannelPromise());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqFrameCodecCtx(), Mockito.anyInt(), Mockito.anyLong(), Http2TestUtil.anyChannelPromise());
        Assertions.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        Assertions.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void flowControlShouldBeResilientToMissingStreams() throws Http2Exception {
        DefaultHttp2Connection conn = new DefaultHttp2Connection(true);
        DefaultHttp2ConnectionEncoder enc = new DefaultHttp2ConnectionEncoder((Http2Connection)conn, (Http2FrameWriter)new DefaultHttp2FrameWriter());
        DefaultHttp2ConnectionDecoder dec = new DefaultHttp2ConnectionDecoder((Http2Connection)conn, (Http2ConnectionEncoder)enc, (Http2FrameReader)new DefaultHttp2FrameReader());
        Http2FrameCodec codec = new Http2FrameCodec((Http2ConnectionEncoder)enc, (Http2ConnectionDecoder)dec, new Http2Settings(), false, true);
        EmbeddedChannel em = new EmbeddedChannel(new ChannelHandler[]{codec});
        Assertions.assertFalse((boolean)codec.consumeBytes(1, 1));
        Assertions.assertTrue((boolean)em.finishAndReleaseAll());
    }

    @Test
    public void entityRequestEntityResponse() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 0, false);
        Http2Stream stream = this.frameCodec.connection().stream(1);
        Assertions.assertNotNull((Object)stream);
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Http2HeadersFrame inboundHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Http2FrameStream stream2 = inboundHeaders.stream();
        Assertions.assertNotNull((Object)stream2);
        Assertions.assertEquals((int)1, (int)stream2.id());
        Assertions.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request, false).stream(stream2), (Object)inboundHeaders);
        Assertions.assertNull(this.inboundHandler.readInbound());
        ByteBuf hello = Http2TestUtil.bb("hello");
        this.frameInboundWriter.writeInboundData(1, hello, 31, true);
        Http2DataFrame inboundData = (Http2DataFrame)this.inboundHandler.readInbound();
        DefaultHttp2DataFrame expected = new DefaultHttp2DataFrame(Http2TestUtil.bb("hello"), true, 31).stream(stream2);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)expected, (Http2Frame)inboundData);
        Assertions.assertNull(this.inboundHandler.readInbound());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2HeadersFrame(this.response, false).stream(stream2)});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeHeaders(this.eqFrameCodecCtx(), Mockito.eq((int)1), (Http2Headers)Mockito.eq((Object)this.response), Mockito.eq((int)0), Mockito.eq((boolean)false), Http2TestUtil.anyChannelPromise());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2DataFrame(Http2TestUtil.bb("world"), true, 27).stream(stream2)});
        ArgumentCaptor outboundData = ArgumentCaptor.forClass(ByteBuf.class);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeData(this.eqFrameCodecCtx(), Mockito.eq((int)1), (ByteBuf)outboundData.capture(), Mockito.eq((int)27), Mockito.eq((boolean)true), Http2TestUtil.anyChannelPromise());
        ByteBuf bb = Http2TestUtil.bb("world");
        Assertions.assertEquals((Object)bb, (Object)outboundData.getValue());
        Assertions.assertEquals((int)1, (int)((ByteBuf)outboundData.getValue()).refCnt());
        bb.release();
        ((ByteBuf)outboundData.getValue()).release();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqFrameCodecCtx(), Mockito.anyInt(), Mockito.anyLong(), Http2TestUtil.anyChannelPromise());
        Assertions.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void sendRstStream() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, true);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assertions.assertNotNull((Object)stream);
        Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_REMOTE, (Object)stream.state());
        Http2HeadersFrame inboundHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)inboundHeaders);
        Assertions.assertTrue((boolean)inboundHeaders.isEndStream());
        Http2FrameStream stream2 = inboundHeaders.stream();
        Assertions.assertNotNull((Object)stream2);
        Assertions.assertEquals((int)3, (int)stream2.id());
        this.channel.writeOutbound(new Object[]{new DefaultHttp2ResetFrame(314L).stream(stream2)});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.eqFrameCodecCtx(), Mockito.eq((int)3), Mockito.eq((long)314L), Http2TestUtil.anyChannelPromise());
        Assertions.assertEquals((Object)Http2Stream.State.CLOSED, (Object)stream.state());
        Assertions.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void receiveRstStream() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assertions.assertNotNull((Object)stream);
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        DefaultHttp2HeadersFrame expectedHeaders = new DefaultHttp2HeadersFrame(this.request, false, 31);
        Http2HeadersFrame actualHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assertions.assertEquals((Object)expectedHeaders.stream(actualHeaders.stream()), (Object)actualHeaders);
        this.frameInboundWriter.writeInboundRstStream(3, Http2Error.NO_ERROR.code());
        DefaultHttp2ResetFrame expectedRst = new DefaultHttp2ResetFrame(Http2Error.NO_ERROR).stream(actualHeaders.stream());
        Http2ResetFrame actualRst = (Http2ResetFrame)this.inboundHandler.readInbound();
        Assertions.assertEquals((Object)expectedRst, (Object)actualRst);
        Assertions.assertNull(this.inboundHandler.readInbound());
    }

    @Test
    public void sendGoAway() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assertions.assertNotNull((Object)stream);
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        ByteBuf debugData = Http2TestUtil.bb("debug");
        ByteBuf expected = debugData.copy();
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR.code(), debugData.retainedDuplicate());
        goAwayFrame.setExtraStreamIds(2);
        this.channel.writeOutbound(new Object[]{goAwayFrame});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway(this.eqFrameCodecCtx(), Mockito.eq((int)7), Mockito.eq((long)Http2Error.NO_ERROR.code()), (ByteBuf)Mockito.eq((Object)expected), Http2TestUtil.anyChannelPromise());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Assertions.assertTrue((boolean)this.channel.isActive());
        expected.release();
        debugData.release();
    }

    @Test
    public void receiveGoaway() throws Exception {
        ByteBuf debugData = Http2TestUtil.bb("foo");
        this.frameInboundWriter.writeInboundGoAway(2, Http2Error.NO_ERROR.code(), debugData);
        DefaultHttp2GoAwayFrame expectedFrame = new DefaultHttp2GoAwayFrame(2, Http2Error.NO_ERROR.code(), Http2TestUtil.bb("foo"));
        Http2GoAwayFrame actualFrame = (Http2GoAwayFrame)this.inboundHandler.readInbound();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)expectedFrame, (Http2Frame)actualFrame);
        Assertions.assertNull(this.inboundHandler.readInbound());
    }

    @Test
    public void unknownFrameTypeShouldThrowAndBeReleased() throws Exception {
        class UnknownHttp2Frame
        extends AbstractReferenceCounted
        implements Http2Frame {
            UnknownHttp2Frame() {
            }

            public String name() {
                return "UNKNOWN";
            }

            protected void deallocate() {
            }

            public ReferenceCounted touch(Object hint) {
                return this;
            }
        }
        UnknownHttp2Frame frame = new UnknownHttp2Frame();
        Assertions.assertEquals((int)1, (int)frame.refCnt());
        ChannelFuture f = this.channel.write((Object)frame);
        f.await();
        Assertions.assertTrue((boolean)f.isDone());
        Assertions.assertFalse((boolean)f.isSuccess());
        MatcherAssert.assertThat((Object)f.cause(), (Matcher)Matchers.instanceOf(UnsupportedMessageTypeException.class));
        Assertions.assertEquals((int)0, (int)frame.refCnt());
    }

    @Test
    public void unknownFrameTypeOnConnectionStream() throws Exception {
        ByteBuf debugData = Http2TestUtil.bb("debug");
        this.frameInboundWriter.writeInboundFrame((byte)11, 0, new Http2Flags(), debugData);
        this.channel.flush();
        Assertions.assertEquals((int)0, (int)debugData.refCnt());
        Assertions.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void goAwayLastStreamIdOverflowed() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(5, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(5);
        Assertions.assertNotNull((Object)stream);
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        ByteBuf debugData = Http2TestUtil.bb("debug");
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(Http2Error.NO_ERROR.code(), debugData.retainedDuplicate());
        goAwayFrame.setExtraStreamIds(Integer.MAX_VALUE);
        this.channel.writeOutbound(new Object[]{goAwayFrame});
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway(this.eqFrameCodecCtx(), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((long)Http2Error.NO_ERROR.code()), (ByteBuf)Mockito.eq((Object)debugData), Http2TestUtil.anyChannelPromise());
        debugData.release();
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        Assertions.assertTrue((boolean)this.channel.isActive());
    }

    @Test
    public void streamErrorShouldFireExceptionForInbound() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assertions.assertNotNull((Object)stream);
        Http2Exception.StreamException streamEx = new Http2Exception.StreamException(3, Http2Error.INTERNAL_ERROR, "foo");
        this.channel.pipeline().fireExceptionCaught((Throwable)streamEx);
        Http2FrameStreamEvent event = (Http2FrameStreamEvent)this.inboundHandler.readInboundMessageOrUserEvent();
        Assertions.assertEquals((Object)Http2FrameStreamEvent.Type.State, (Object)event.type());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)event.stream().state());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.inboundHandler.readInboundMessageOrUserEvent();
        Assertions.assertNotNull((Object)headersFrame);
        Http2FrameStreamException e = (Http2FrameStreamException)Assertions.assertThrows(Http2FrameStreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                Http2FrameCodecTest.this.inboundHandler.checkException();
            }
        });
        Assertions.assertEquals((Object)streamEx, (Object)e.getCause());
        Assertions.assertNull(this.inboundHandler.readInboundMessageOrUserEvent());
    }

    @Test
    public void streamErrorShouldNotFireExceptionForOutbound() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(3);
        Assertions.assertNotNull((Object)stream);
        Http2Exception.StreamException streamEx = new Http2Exception.StreamException(3, Http2Error.INTERNAL_ERROR, "foo");
        this.frameCodec.onError(this.frameCodec.ctx, true, (Throwable)streamEx);
        Http2FrameStreamEvent event = (Http2FrameStreamEvent)this.inboundHandler.readInboundMessageOrUserEvent();
        Assertions.assertEquals((Object)Http2FrameStreamEvent.Type.State, (Object)event.type());
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)event.stream().state());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.inboundHandler.readInboundMessageOrUserEvent();
        Assertions.assertNotNull((Object)headersFrame);
        this.inboundHandler.checkException();
        Assertions.assertNull(this.inboundHandler.readInboundMessageOrUserEvent());
    }

    @Test
    public void windowUpdateFrameDecrementsConsumedBytes() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Connection connection = this.frameCodec.connection();
        Http2Stream stream = connection.stream(3);
        Assertions.assertNotNull((Object)stream);
        ByteBuf data = Unpooled.buffer((int)100).writeZero(100);
        this.frameInboundWriter.writeInboundData(3, data, 0, false);
        Http2HeadersFrame inboundHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)inboundHeaders);
        Assertions.assertNotNull((Object)inboundHeaders.stream());
        Http2FrameStream stream2 = inboundHeaders.stream();
        int before = ((Http2LocalFlowController)connection.local().flowController()).unconsumedBytes(stream);
        ChannelFuture f = this.channel.write((Object)new DefaultHttp2WindowUpdateFrame(100).stream(stream2));
        int after = ((Http2LocalFlowController)connection.local().flowController()).unconsumedBytes(stream);
        Assertions.assertEquals((int)100, (int)(before - after));
        Assertions.assertTrue((boolean)f.isSuccess());
    }

    @Test
    public void windowUpdateMayFail() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        Http2Connection connection = this.frameCodec.connection();
        Http2Stream stream = connection.stream(3);
        Assertions.assertNotNull((Object)stream);
        Http2HeadersFrame inboundHeaders = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)inboundHeaders);
        Http2FrameStream stream2 = inboundHeaders.stream();
        ChannelFuture f = this.channel.write((Object)new DefaultHttp2WindowUpdateFrame(100).stream(stream2));
        Assertions.assertTrue((boolean)f.isDone());
        Assertions.assertFalse((boolean)f.isSuccess());
        MatcherAssert.assertThat((Object)f.cause(), (Matcher)Matchers.instanceOf(Http2Exception.class));
    }

    @Test
    public void inboundWindowUpdateShouldBeForwarded() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 31, false);
        this.frameInboundWriter.writeInboundWindowUpdate(3, 100);
        this.frameInboundWriter.writeInboundWindowUpdate(0, 100);
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        Http2WindowUpdateFrame windowUpdateFrame = (Http2WindowUpdateFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)windowUpdateFrame);
        Assertions.assertEquals((int)3, (int)windowUpdateFrame.stream().id());
        Assertions.assertEquals((int)100, (int)windowUpdateFrame.windowSizeIncrement());
        Assertions.assertNull(this.inboundHandler.readInbound());
    }

    @Test
    public void streamZeroWindowUpdateIncrementsConnectionWindow() throws Http2Exception {
        Http2Connection connection = this.frameCodec.connection();
        Http2LocalFlowController localFlow = (Http2LocalFlowController)connection.local().flowController();
        int initialWindowSizeBefore = localFlow.initialWindowSize();
        Http2Stream connectionStream = connection.connectionStream();
        int connectionWindowSizeBefore = localFlow.windowSize(connectionStream);
        ((DefaultHttp2LocalFlowController)localFlow).windowUpdateRatio(connectionStream, 0.999f);
        int windowUpdate = 1024;
        this.channel.write((Object)new DefaultHttp2WindowUpdateFrame(windowUpdate));
        Assertions.assertEquals((int)initialWindowSizeBefore, (int)localFlow.initialWindowSize());
        Assertions.assertEquals((int)(connectionWindowSizeBefore + windowUpdate), (int)localFlow.windowSize(connectionStream));
    }

    @Test
    public void windowUpdateDoesNotOverflowConnectionWindow() {
        Http2Connection connection = this.frameCodec.connection();
        Http2LocalFlowController localFlow = (Http2LocalFlowController)connection.local().flowController();
        int initialWindowSizeBefore = localFlow.initialWindowSize();
        this.channel.write((Object)new DefaultHttp2WindowUpdateFrame(Integer.MAX_VALUE));
        Assertions.assertEquals((int)initialWindowSizeBefore, (int)localFlow.initialWindowSize());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)localFlow.windowSize(connection.connectionStream()));
    }

    @Test
    public void writeUnknownFrame() {
        Http2FrameCodec.DefaultHttp2FrameStream stream = this.frameCodec.newStream();
        ByteBuf buffer = Unpooled.buffer().writeByte(1);
        DefaultHttp2UnknownFrame unknownFrame = new DefaultHttp2UnknownFrame(20, new Http2Flags().ack(true), buffer);
        unknownFrame.stream((Http2FrameStream)stream);
        this.channel.write((Object)unknownFrame);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeFrame(this.eqFrameCodecCtx(), Mockito.eq((byte)unknownFrame.frameType()), Mockito.eq((int)unknownFrame.stream().id()), (Http2Flags)Mockito.eq((Object)unknownFrame.flags()), (ByteBuf)Mockito.eq((Object)buffer), (ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    @Test
    public void sendSettingsFrame() {
        Http2Settings settings = new Http2Settings();
        this.channel.write((Object)new DefaultHttp2SettingsFrame(settings));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettings(this.eqFrameCodecCtx(), (Http2Settings)Mockito.same((Object)settings), (ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void newOutboundStream() {
        Http2FrameCodec.DefaultHttp2FrameStream stream = this.frameCodec.newStream();
        Assertions.assertNotNull((Object)stream);
        Assertions.assertFalse((boolean)Http2CodecUtil.isStreamIdValid((int)stream.id()));
        DefaultPromise listenerExecuted = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), false).stream((Http2FrameStream)stream)).addListener((GenericFutureListener)new ChannelFutureListener((Http2FrameStream)stream, (Promise)listenerExecuted){
            final /* synthetic */ Http2FrameStream val$stream;
            final /* synthetic */ Promise val$listenerExecuted;
            {
                this.val$stream = http2FrameStream;
                this.val$listenerExecuted = promise;
            }

            public void operationComplete(ChannelFuture future) throws Exception {
                Assertions.assertTrue((boolean)future.isSuccess());
                Assertions.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)this.val$stream.id()));
                this.val$listenerExecuted.setSuccess(null);
            }
        });
        ByteBuf data = Unpooled.buffer().writeZero(100);
        ChannelFuture f = this.channel.writeAndFlush((Object)new DefaultHttp2DataFrame(data).stream((Http2FrameStream)stream));
        Assertions.assertTrue((boolean)f.isSuccess());
        listenerExecuted.syncUninterruptibly();
        Assertions.assertTrue((boolean)listenerExecuted.isSuccess());
    }

    @Test
    public void newOutboundStreamsShouldBeBuffered() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().encoderEnforceMaxConcurrentStreams(true), new Http2Settings().maxConcurrentStreams(1L));
        Http2FrameCodec.DefaultHttp2FrameStream stream1 = this.frameCodec.newStream();
        Http2FrameCodec.DefaultHttp2FrameStream stream2 = this.frameCodec.newStream();
        ChannelPromise promise1 = this.channel.newPromise();
        ChannelPromise promise2 = this.channel.newPromise();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream1), promise1);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream2), promise2);
        Assertions.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)stream1.id()));
        this.channel.runPendingTasks();
        Assertions.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)stream2.id()));
        Assertions.assertTrue((boolean)promise1.syncUninterruptibly().isSuccess());
        Assertions.assertFalse((boolean)promise2.isDone());
        this.frameInboundWriter.writeInboundSettings(new Http2Settings().maxConcurrentStreams(2L));
        this.channel.flush();
        Assertions.assertTrue((boolean)promise2.syncUninterruptibly().isSuccess());
    }

    @Test
    public void multipleNewOutboundStreamsShouldBeBuffered() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().encoderEnforceMaxConcurrentStreams(true), new Http2Settings().maxConcurrentStreams(1L));
        Http2FrameCodec.DefaultHttp2FrameStream stream1 = this.frameCodec.newStream();
        Http2FrameCodec.DefaultHttp2FrameStream stream2 = this.frameCodec.newStream();
        Http2FrameCodec.DefaultHttp2FrameStream stream3 = this.frameCodec.newStream();
        ChannelPromise promise1 = this.channel.newPromise();
        ChannelPromise promise2 = this.channel.newPromise();
        ChannelPromise promise3 = this.channel.newPromise();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream1), promise1);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream2), promise2);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream3), promise3);
        Assertions.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)stream1.id()));
        this.channel.runPendingTasks();
        Assertions.assertTrue((boolean)Http2CodecUtil.isStreamIdValid((int)stream2.id()));
        Assertions.assertTrue((boolean)promise1.syncUninterruptibly().isSuccess());
        Assertions.assertFalse((boolean)promise2.isDone());
        Assertions.assertFalse((boolean)promise3.isDone());
        this.frameInboundWriter.writeInboundSettings(new Http2Settings().maxConcurrentStreams(2L));
        this.channel.flush();
        Assertions.assertTrue((boolean)promise2.syncUninterruptibly().isSuccess());
        Assertions.assertFalse((boolean)promise3.isDone());
        this.frameInboundWriter.writeInboundSettings(new Http2Settings().maxConcurrentStreams(3L));
        this.channel.flush();
        Assertions.assertTrue((boolean)promise3.syncUninterruptibly().isSuccess());
        Assertions.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test
    public void doNotLeakOnFailedInitializationForChannels() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer(), new Http2Settings().maxConcurrentStreams(2L));
        Http2FrameCodec.DefaultHttp2FrameStream stream1 = this.frameCodec.newStream();
        Http2FrameCodec.DefaultHttp2FrameStream stream2 = this.frameCodec.newStream();
        ChannelPromise stream1HeaderPromise = this.channel.newPromise();
        ChannelPromise stream2HeaderPromise = this.channel.newPromise();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream1), stream1HeaderPromise);
        this.channel.runPendingTasks();
        this.frameInboundWriter.writeInboundGoAway(stream1.id(), 0L, Unpooled.EMPTY_BUFFER);
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream2), stream2HeaderPromise);
        this.channel.runPendingTasks();
        Assertions.assertTrue((boolean)stream1HeaderPromise.syncUninterruptibly().isSuccess());
        Assertions.assertTrue((boolean)stream2HeaderPromise.isDone());
        Assertions.assertEquals((int)0, (int)this.frameCodec.numInitializingStreams());
        Assertions.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test
    public void streamIdentifiersExhausted() throws Http2Exception {
        int maxServerStreamId = 0x7FFFFFFE;
        Assertions.assertNotNull((Object)this.frameCodec.connection().local().createStream(maxServerStreamId, false));
        Http2FrameCodec.DefaultHttp2FrameStream stream = this.frameCodec.newStream();
        Assertions.assertNotNull((Object)stream);
        ChannelPromise writePromise = this.channel.newPromise();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream), writePromise);
        Http2GoAwayFrame goAwayFrame = (Http2GoAwayFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)goAwayFrame);
        Assertions.assertEquals((long)Http2Error.NO_ERROR.code(), (long)goAwayFrame.errorCode());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)goAwayFrame.lastStreamId());
        goAwayFrame.release();
        MatcherAssert.assertThat((Object)writePromise.cause(), (Matcher)Matchers.instanceOf(Http2NoMoreStreamIdsException.class));
    }

    @Test
    public void receivePing() throws Http2Exception {
        this.frameInboundWriter.writeInboundPing(false, 12345L);
        Http2PingFrame pingFrame = (Http2PingFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)pingFrame);
        Assertions.assertEquals((long)12345L, (long)pingFrame.content());
        Assertions.assertFalse((boolean)pingFrame.ack());
    }

    @Test
    public void sendPing() {
        this.channel.writeAndFlush((Object)new DefaultHttp2PingFrame(12345L));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writePing(this.eqFrameCodecCtx(), Mockito.eq((boolean)false), Mockito.eq((long)12345L), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void receiveSettings() throws Http2Exception {
        Http2Settings settings = new Http2Settings().maxConcurrentStreams(1L);
        this.frameInboundWriter.writeInboundSettings(settings);
        Http2SettingsFrame settingsFrame = (Http2SettingsFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)settingsFrame);
        Assertions.assertEquals((Object)settings, (Object)settingsFrame.settings());
    }

    @Test
    public void sendSettings() {
        Http2Settings settings = new Http2Settings().maxConcurrentStreams(1L);
        this.channel.writeAndFlush((Object)new DefaultHttp2SettingsFrame(settings));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettings(this.eqFrameCodecCtx(), (Http2Settings)Mockito.eq((Object)settings), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void iterateActiveStreams() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().encoderEnforceMaxConcurrentStreams(true), new Http2Settings().maxConcurrentStreams(1L));
        this.frameInboundWriter.writeInboundHeaders(3, this.request, 0, false);
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)this.inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        Http2FrameStream activeInbond = headersFrame.stream();
        Http2FrameCodec.DefaultHttp2FrameStream activeOutbound = this.frameCodec.newStream();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)activeOutbound));
        Http2FrameCodec.DefaultHttp2FrameStream bufferedOutbound = this.frameCodec.newStream();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)bufferedOutbound));
        Http2FrameCodec.DefaultHttp2FrameStream idleStream = this.frameCodec.newStream();
        final HashSet activeStreams = new HashSet();
        this.frameCodec.forEachActiveStream(new Http2FrameStreamVisitor(){

            public boolean visit(Http2FrameStream stream) {
                activeStreams.add(stream);
                return true;
            }
        });
        Assertions.assertEquals((int)2, (int)activeStreams.size());
        HashSet<Object> expectedStreams = new HashSet<Object>();
        expectedStreams.add(activeInbond);
        expectedStreams.add(activeOutbound);
        Assertions.assertEquals(expectedStreams, activeStreams);
    }

    @Test
    public void autoAckPingTrue() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().autoAckPingFrame(true), new Http2Settings());
        this.frameInboundWriter.writeInboundPing(false, 8L);
        Http2PingFrame frame = (Http2PingFrame)this.inboundHandler.readInbound();
        Assertions.assertFalse((boolean)frame.ack());
        Assertions.assertEquals((long)8L, (long)frame.content());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writePing(this.eqFrameCodecCtx(), Mockito.eq((boolean)true), Mockito.eq((long)8L), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void autoAckPingFalse() throws Exception {
        this.setUp(Http2FrameCodecBuilder.forServer().autoAckPingFrame(false), new Http2Settings());
        this.frameInboundWriter.writeInboundPing(false, 8L);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writePing(this.eqFrameCodecCtx(), Mockito.eq((boolean)true), Mockito.eq((long)8L), Http2TestUtil.anyChannelPromise());
        Http2PingFrame frame = (Http2PingFrame)this.inboundHandler.readInbound();
        Assertions.assertFalse((boolean)frame.ack());
        Assertions.assertEquals((long)8L, (long)frame.content());
        this.channel.writeAndFlush((Object)new DefaultHttp2PingFrame(8L, true));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writePing(this.eqFrameCodecCtx(), Mockito.eq((boolean)true), Mockito.eq((long)8L), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void streamShouldBeOpenInListener() {
        Http2FrameCodec.DefaultHttp2FrameStream stream2 = this.frameCodec.newStream();
        Assertions.assertEquals((Object)Http2Stream.State.IDLE, (Object)stream2.state());
        AtomicBoolean listenerExecuted = new AtomicBoolean();
        this.channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()).stream((Http2FrameStream)stream2)).addListener((GenericFutureListener)new ChannelFutureListener((Http2FrameStream)stream2, listenerExecuted){
            final /* synthetic */ Http2FrameStream val$stream2;
            final /* synthetic */ AtomicBoolean val$listenerExecuted;
            {
                this.val$stream2 = http2FrameStream;
                this.val$listenerExecuted = atomicBoolean;
            }

            public void operationComplete(ChannelFuture future) throws Exception {
                Assertions.assertTrue((boolean)future.isSuccess());
                Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)this.val$stream2.state());
                this.val$listenerExecuted.set(true);
            }
        });
        Assertions.assertTrue((boolean)listenerExecuted.get());
    }

    @Test
    public void upgradeEventNoRefCntError() throws Exception {
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 31, false);
        Constructor constructor = HttpServerUpgradeHandler.UpgradeEvent.class.getDeclaredConstructor(CharSequence.class, FullHttpRequest.class);
        Assumptions.assumeTrue((ReflectionUtil.trySetAccessible(constructor, (boolean)true) == null ? 1 : 0) != 0);
        HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)constructor.newInstance("HTTP/2", new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/"));
        this.channel.pipeline().fireUserEventTriggered((Object)upgradeEvent);
        Assertions.assertEquals((int)1, (int)upgradeEvent.refCnt());
    }

    @Test
    public void upgradeWithoutFlowControlling() throws Exception {
        this.channel.pipeline().addAfter(this.frameCodec.ctx.name(), null, (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof Http2DataFrame) {
                    Http2DataFrame data = (Http2DataFrame)msg;
                    ctx.writeAndFlush((Object)new DefaultHttp2WindowUpdateFrame(data.initialFlowControlledBytes()).stream(data.stream())).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            Throwable cause = future.cause();
                            if (cause != null) {
                                ctx.fireExceptionCaught(cause);
                            }
                        }
                    });
                }
                ReferenceCountUtil.release((Object)msg);
            }
        });
        this.frameInboundWriter.writeInboundHeaders(1, this.request, 31, false);
        Constructor constructor = HttpServerUpgradeHandler.UpgradeEvent.class.getDeclaredConstructor(CharSequence.class, FullHttpRequest.class);
        Assumptions.assumeTrue((ReflectionUtil.trySetAccessible(constructor, (boolean)true) == null ? 1 : 0) != 0);
        String longString = new String(new char[70000]).replace("\u0000", "*");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/", Http2TestUtil.bb(longString));
        HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)constructor.newInstance("HTTP/2", request);
        this.channel.pipeline().fireUserEventTriggered((Object)upgradeEvent);
    }

    @Test
    public void priorityForNonExistingStream() {
        this.writeHeaderAndAssert(1);
        this.frameInboundWriter.writeInboundPriority(3, 1, (short)31, true);
    }

    @Test
    public void priorityForExistingStream() {
        this.writeHeaderAndAssert(1);
        this.writeHeaderAndAssert(3);
        this.frameInboundWriter.writeInboundPriority(3, 1, (short)31, true);
        this.assertInboundStreamFrame(3, (Http2StreamFrame)new DefaultHttp2PriorityFrame(1, 31, true));
    }

    private void writeHeaderAndAssert(int streamId) {
        this.frameInboundWriter.writeInboundHeaders(streamId, this.request, 31, false);
        Http2Stream stream = this.frameCodec.connection().stream(streamId);
        Assertions.assertNotNull((Object)stream);
        Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)stream.state());
        this.assertInboundStreamFrame(streamId, (Http2StreamFrame)new DefaultHttp2HeadersFrame(this.request, false, 31));
    }

    private void assertInboundStreamFrame(int expectedId, Http2StreamFrame streamFrame) {
        Http2StreamFrame inboundFrame = (Http2StreamFrame)this.inboundHandler.readInbound();
        Http2FrameStream stream2 = inboundFrame.stream();
        Assertions.assertNotNull((Object)stream2);
        Assertions.assertEquals((int)expectedId, (int)stream2.id());
        Assertions.assertEquals((Object)inboundFrame, (Object)streamFrame.stream(stream2));
    }

    private ChannelHandlerContext eqFrameCodecCtx() {
        return (ChannelHandlerContext)Mockito.eq((Object)this.frameCodec.ctx);
    }
}

