/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.epoll;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.bootstrap.ServerBootstrap;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.SelectStrategy;
import org.apache.hive.druid.io.netty.channel.SelectStrategyFactory;
import org.apache.hive.druid.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.hive.druid.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hive.druid.io.netty.testsuite.transport.TestsuitePermutation;
import org.apache.hive.druid.io.netty.testsuite.transport.socket.SocketStringEchoTest;
import org.apache.hive.druid.io.netty.util.IntSupplier;
import org.apache.hive.druid.io.netty.util.concurrent.DefaultThreadFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public class EpollSocketStringEchoBusyWaitTest
extends SocketStringEchoTest {
    private static EventLoopGroup EPOLL_LOOP;

    @BeforeAll
    public static void setup() throws Exception {
        EPOLL_LOOP = new EpollEventLoopGroup(2, (ThreadFactory)new DefaultThreadFactory("testsuite-epoll-busy-wait", true), new SelectStrategyFactory(){

            public SelectStrategy newSelectStrategy() {
                return new SelectStrategy(){

                    public int calculateStrategy(IntSupplier selectSupplier, boolean hasTasks) {
                        return -3;
                    }
                };
            }
        });
    }

    @AfterAll
    public static void teardown() throws Exception {
        if (EPOLL_LOOP != null) {
            EPOLL_LOOP.shutdownGracefully();
        }
    }

    protected List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> newFactories() {
        ArrayList<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> list = new ArrayList<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>>();
        final TestsuitePermutation.BootstrapFactory<ServerBootstrap> sbf = EpollSocketStringEchoBusyWaitTest.serverSocket();
        final TestsuitePermutation.BootstrapFactory<Bootstrap> cbf = EpollSocketStringEchoBusyWaitTest.clientSocket();
        list.add(new TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>(){

            public ServerBootstrap newServerInstance() {
                return (ServerBootstrap)sbf.newInstance();
            }

            public Bootstrap newClientInstance() {
                return (Bootstrap)cbf.newInstance();
            }
        });
        return list;
    }

    private static TestsuitePermutation.BootstrapFactory<ServerBootstrap> serverSocket() {
        return new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(EPOLL_LOOP, EPOLL_LOOP).channel(EpollServerSocketChannel.class);
            }
        };
    }

    private static TestsuitePermutation.BootstrapFactory<Bootstrap> clientSocket() {
        return new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(EPOLL_LOOP)).channel(EpollSocketChannel.class);
            }
        };
    }
}

