/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.epoll;

import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hive.druid.io.netty.channel.epoll.EpollSocketTestPermutation;
import org.apache.hive.druid.io.netty.channel.unix.DomainDatagramChannel;
import org.apache.hive.druid.io.netty.channel.unix.DomainDatagramPacket;
import org.apache.hive.druid.io.netty.channel.unix.DomainSocketAddress;
import org.apache.hive.druid.io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import org.apache.hive.druid.io.netty.testsuite.transport.TestsuitePermutation;
import org.apache.hive.druid.io.netty.testsuite.transport.socket.DatagramUnicastTest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class EpollDomainDatagramUnicastTest
extends DatagramUnicastTest {
    EpollDomainDatagramUnicastTest() {
    }

    @Test
    void testBind(TestInfo testInfo) throws Throwable {
        this.run(testInfo, (AbstractComboTestsuiteTest.Runner)new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                EpollDomainDatagramUnicastTest.this.testBind(bootstrap2);
            }
        });
    }

    private void testBind(Bootstrap cb) throws Throwable {
        Channel channel = null;
        try {
            channel = ((Bootstrap)cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind(this.newSocketAddress()).sync().channel();
            ((ObjectAssert)Assertions.assertThat((Object)channel.localAddress()).isNotNull()).isInstanceOf(DomainSocketAddress.class);
        }
        catch (Throwable throwable) {
            EpollDomainDatagramUnicastTest.closeChannel(channel);
            throw throwable;
        }
        EpollDomainDatagramUnicastTest.closeChannel((Channel)channel);
    }

    protected boolean supportDisconnect() {
        return false;
    }

    protected boolean isConnected(Channel channel) {
        return ((DomainDatagramChannel)channel).isConnected();
    }

    protected List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> newFactories() {
        return EpollSocketTestPermutation.INSTANCE.domainDatagram();
    }

    protected SocketAddress newSocketAddress() {
        return EpollSocketTestPermutation.newDomainSocketAddress();
    }

    protected Channel setupClientChannel(Bootstrap cb, final byte[] bytes, final CountDownLatch latch, final AtomicReference<Throwable> errorRef) throws Throwable {
        cb.handler((ChannelHandler)new SimpleChannelInboundHandler<DomainDatagramPacket>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void channelRead0(ChannelHandlerContext ctx, DomainDatagramPacket msg) {
                try {
                    ByteBuf buf = (ByteBuf)msg.content();
                    org.junit.jupiter.api.Assertions.assertEquals((int)bytes.length, (int)buf.readableBytes());
                    for (int i = 0; i < bytes.length; ++i) {
                        org.junit.jupiter.api.Assertions.assertEquals((byte)bytes[i], (byte)buf.getByte(buf.readerIndex() + i));
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)ctx.channel().localAddress(), (Object)msg.recipient());
                }
                finally {
                    latch.countDown();
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                errorRef.compareAndSet(null, cause);
            }
        });
        return cb.bind(this.newSocketAddress()).sync().channel();
    }

    protected Channel setupServerChannel(Bootstrap sb, final byte[] bytes, final SocketAddress sender, final CountDownLatch latch, final AtomicReference<Throwable> errorRef, final boolean echo) throws Throwable {
        sb.handler((ChannelHandler)new SimpleChannelInboundHandler<DomainDatagramPacket>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void channelRead0(ChannelHandlerContext ctx, DomainDatagramPacket msg) {
                try {
                    if (sender == null) {
                        org.junit.jupiter.api.Assertions.assertNotNull((Object)msg.sender());
                    } else {
                        org.junit.jupiter.api.Assertions.assertEquals((Object)sender, (Object)msg.sender());
                    }
                    ByteBuf buf = (ByteBuf)msg.content();
                    org.junit.jupiter.api.Assertions.assertEquals((int)bytes.length, (int)buf.readableBytes());
                    for (int i = 0; i < bytes.length; ++i) {
                        org.junit.jupiter.api.Assertions.assertEquals((byte)bytes[i], (byte)buf.getByte(buf.readerIndex() + i));
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((Object)ctx.channel().localAddress(), (Object)msg.recipient());
                    if (echo) {
                        ctx.writeAndFlush((Object)new DomainDatagramPacket(buf.retainedDuplicate(), (DomainSocketAddress)msg.sender()));
                    }
                }
                finally {
                    latch.countDown();
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                errorRef.compareAndSet(null, cause);
            }
        });
        return sb.bind(this.newSocketAddress()).sync().channel();
    }

    protected ChannelFuture write(Channel cc, ByteBuf buf, SocketAddress remote, DatagramUnicastTest.WrapType wrapType) {
        switch (wrapType) {
            case DUP: {
                return cc.write((Object)new DomainDatagramPacket(buf.retainedDuplicate(), (DomainSocketAddress)remote));
            }
            case SLICE: {
                return cc.write((Object)new DomainDatagramPacket(buf.retainedSlice(), (DomainSocketAddress)remote));
            }
            case READ_ONLY: {
                return cc.write((Object)new DomainDatagramPacket(buf.retain().asReadOnly(), (DomainSocketAddress)remote));
            }
            case NONE: {
                return cc.write((Object)new DomainDatagramPacket(buf.retain(), (DomainSocketAddress)remote));
            }
        }
        throw new Error("unknown wrap type: " + wrapType);
    }
}

