/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.lookup.cache;

import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.io.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.hive.druid.io.druid.server.lookup.cache.LookupExtractorFactoryMapContainer;
import org.junit.Assert;
import org.junit.Test;

public class LookupExtractorFactoryMapContainerTest {
    private final ObjectMapper mapper = new DefaultObjectMapper();
    private final String jsonStr;
    private final LookupExtractorFactoryMapContainer testContainer;

    public LookupExtractorFactoryMapContainerTest() {
        this.mapper.registerSubtypes(new Class[]{MapLookupExtractorFactory.class});
        this.jsonStr = "{\n  \"version\": \"v1\",\n  \"lookupExtractorFactory\": {\n    \"type\": \"map\",\n    \"map\": {\"k\": \"v\"},\n    \"isOneToOne\": true\n  }\n}\n";
        this.testContainer = new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"type", (Object)"map", (Object)"map", (Object)ImmutableMap.of((Object)"k", (Object)"v"), (Object)"isOneToOne", (Object)true));
    }

    @Test
    public void testSerde() throws Exception {
        LookupExtractorFactoryMapContainer actual = (LookupExtractorFactoryMapContainer)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(this.jsonStr, LookupExtractorFactoryMapContainer.class)), LookupExtractorFactoryMapContainer.class);
        Assert.assertEquals((Object)"v1", (Object)actual.getVersion());
        Assert.assertEquals((Object)this.testContainer, (Object)actual);
    }

    @Test
    public void testReplaces() throws Exception {
        LookupExtractorFactoryMapContainer l0 = new LookupExtractorFactoryMapContainer(null, (Map)ImmutableMap.of());
        LookupExtractorFactoryMapContainer l1 = new LookupExtractorFactoryMapContainer(null, (Map)ImmutableMap.of());
        LookupExtractorFactoryMapContainer l2 = new LookupExtractorFactoryMapContainer("V2", (Map)ImmutableMap.of());
        LookupExtractorFactoryMapContainer l3 = new LookupExtractorFactoryMapContainer("V3", (Map)ImmutableMap.of());
        Assert.assertFalse((boolean)l0.replaces(l1));
        Assert.assertFalse((boolean)l1.replaces(l2));
        Assert.assertTrue((boolean)l2.replaces(l1));
        Assert.assertFalse((boolean)l2.replaces(l3));
        Assert.assertTrue((boolean)l3.replaces(l2));
    }

    @Test
    public void testInterchangeability1() throws Exception {
        LookupExtractorFactoryMapContainer actual = (LookupExtractorFactoryMapContainer)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(this.jsonStr, LookupExtractorFactoryContainer.class)), LookupExtractorFactoryMapContainer.class);
        Assert.assertEquals((Object)"v1", (Object)actual.getVersion());
        Assert.assertEquals((Object)this.testContainer, (Object)actual);
    }

    @Test
    public void testInterchangeability2() throws Exception {
        LookupExtractorFactoryContainer actual = (LookupExtractorFactoryContainer)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(this.jsonStr, LookupExtractorFactoryMapContainer.class)), LookupExtractorFactoryContainer.class);
        Assert.assertEquals((Object)"v1", (Object)actual.getVersion());
        Assert.assertEquals((Object)actual, (Object)new LookupExtractorFactoryContainer("v1", (LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"k", (Object)"v"), true)));
    }
}

