/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.ReplicationThrottler;
import org.apache.hive.druid.io.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorRuleRunner;
import org.apache.hive.druid.io.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.IntervalDropRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidCoordinatorRuleRunnerTest {
    private DruidCoordinator coordinator;
    private LoadQueuePeon mockPeon;
    private List<DataSegment> availableSegments;
    private DruidCoordinatorRuleRunner ruleRunner;
    private ServiceEmitter emitter;
    private MetadataRuleManager databaseRuleManager;

    @Before
    public void setUp() {
        this.coordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        this.mockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        this.emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        this.databaseRuleManager = (MetadataRuleManager)EasyMock.createMock(MetadataRuleManager.class);
        DateTime start = DateTimes.of((String)"2012-01-01");
        this.availableSegments = Lists.newArrayList();
        for (int i = 0; i < 24; ++i) {
            this.availableSegments.add(new DataSegment("test", new Interval((ReadableInstant)start, (ReadableInstant)start.plusHours(1)), DateTimes.nowUtc().toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L));
            start = start.plusHours(1);
        }
        this.ruleRunner = new DruidCoordinatorRuleRunner(new ReplicationThrottler(24, 1), this.coordinator);
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.coordinator});
        EasyMock.verify((Object[])new Object[]{this.databaseRuleManager});
    }

    @Test
    public void testRunThreeTiersOneReplicant() throws Exception {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T06:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"cold", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"normal", (Object)Stream.of(new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"cold", (Object)Stream.of(new ServerHolder(new DruidServer("serverCold", "hostCold", null, 1000L, ServerType.HISTORICAL, "cold", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMaxSegmentsToMove(5).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)6L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)6L, (long)stats.getTieredStat("assignedCount", "normal"));
        Assert.assertEquals((long)12L, (long)stats.getTieredStat("assignedCount", "cold"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunTwoTiersTwoReplicants() throws Exception {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T06:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)2)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"cold", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon), new ServerHolder(new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"cold", (Object)Stream.of(new ServerHolder(new DruidServer("serverCold", "hostCold", null, 1000L, ServerType.HISTORICAL, "cold", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)12L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)18L, (long)stats.getTieredStat("assignedCount", "cold"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunTwoTiersWithExistingSegments() throws Exception {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer normServer = new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment availableSegment : this.availableSegments) {
            normServer.addDataSegment(availableSegment);
        }
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"normal", (Object)Stream.of(new ServerHolder(normServer.toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)12L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)0L, (long)stats.getTieredStat("assignedCount", "normal"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunTwoTiersTierDoesNotExist() throws Exception {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        this.emitter.emit((ServiceEventBuilder)EasyMock.anyObject());
        EasyMock.expectLastCall().times(12);
        EasyMock.replay((Object[])new Object[]{this.emitter});
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)Stream.of(new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withEmitter(this.emitter).withDruidCluster(druidCluster).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        this.ruleRunner.run(params);
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.emitter});
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testRunRuleDoesNotExist() throws Exception {
        this.mockCoordinator();
        this.emitter.emit((ServiceEventBuilder)EasyMock.anyObject());
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.emitter});
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-02T00:00:00.000Z/2012-01-03T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1))})).atLeastOnce();
        EasyMock.expect((Object)this.mockPeon.getLoadQueueSize()).andReturn((Object)0L).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager, this.mockPeon});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)Stream.of(new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withEmitter(this.emitter).withDruidCluster(druidCluster).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).build();
        this.ruleRunner.run(params);
        EasyMock.verify((Object[])new Object[]{this.emitter, this.mockPeon});
    }

    @Test
    public void testDropRemove() throws Exception {
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.coordinator.getDynamicConfigs()).andReturn((Object)this.createCoordinatorDynamicConfig()).anyTimes();
        this.coordinator.removeSegment((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.coordinator});
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1)), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server = new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.availableSegments) {
            server.addDataSegment(segment);
        }
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)Stream.of(new ServerHolder(server.toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMillisToWaitBeforeDeleting(0L).build()).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)12L, (long)stats.getGlobalStat("deletedCount"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.coordinator});
    }

    @Test
    public void testDropTooManyInSameTier() throws Exception {
        this.mockCoordinator();
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1)), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        server1.addDataSegment(this.availableSegments.get(0));
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.availableSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)Stream.of(new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMillisToWaitBeforeDeleting(0L).build()).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "normal"));
        Assert.assertEquals((long)12L, (long)stats.getGlobalStat("deletedCount"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDropTooManyInDifferentTiers() throws Exception {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        server1.addDataSegment(this.availableSegments.get(0));
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.availableSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"normal", (Object)Stream.of(new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMillisToWaitBeforeDeleting(0L).build()).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "normal"));
        Assert.assertEquals((long)12L, (long)stats.getGlobalStat("deletedCount"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDontDropInDifferentTiers() throws Exception {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T12:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1)), new IntervalDropRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-02T00:00:00.000Z"))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment segment : this.availableSegments) {
            server2.addDataSegment(segment);
        }
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"normal", (Object)Stream.of(new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMillisToWaitBeforeDeleting(0L).build()).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertTrue((boolean)stats.getTiers("droppedCount").isEmpty());
        Assert.assertEquals((long)12L, (long)stats.getGlobalStat("deletedCount"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
    }

    @Test
    public void testDropServerActuallyServesSegment() throws Exception {
        this.mockCoordinator();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2012-01-01T01:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)0))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidServer server1 = new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        server1.addDataSegment(this.availableSegments.get(0));
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        server2.addDataSegment(this.availableSegments.get(1));
        DruidServer server3 = new DruidServer("serverNorm3", "hostNorm3", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        server3.addDataSegment(this.availableSegments.get(1));
        server3.addDataSegment(this.availableSegments.get(2));
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        LoadQueuePeon anotherMockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        EasyMock.expect((Object)anotherMockPeon.getLoadQueueSize()).andReturn((Object)10L).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{anotherMockPeon});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)Stream.of(new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(server2.toImmutableDruidServer(), anotherMockPeon), new ServerHolder(server3.toImmutableDruidServer(), anotherMockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMillisToWaitBeforeDeleting(0L).build()).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "normal"));
        exec.shutdown();
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        EasyMock.verify((Object[])new Object[]{anotherMockPeon});
    }

    @Test
    public void testReplicantThrottle() throws Exception {
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2013-01-01T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)2))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon), new ServerHolder(new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)48L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        DataSegment overFlowSegment = new DataSegment("test", Intervals.of((String)"2012-02-01/2012-02-02"), DateTimes.nowUtc().toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 0L);
        afterParams = this.ruleRunner.run(new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withEmitter(this.emitter).withAvailableSegments(Arrays.asList(overFlowSegment)).withDatabaseRuleManager(this.databaseRuleManager).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).build());
        stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        exec.shutdown();
    }

    @Test
    public void testReplicantThrottleAcrossTiers() throws Exception {
        EasyMock.expect((Object)this.coordinator.getDynamicConfigs()).andReturn((Object)CoordinatorDynamicConfig.builder().withReplicationThrottleLimit(7).withReplicantLifetime(1).withMaxSegmentsInNodeLoadingQueue(1000).build()).atLeastOnce();
        this.coordinator.removeSegment((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinator});
        this.mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2013-01-01T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"hot", (Object)1, (Object)"_default_tier", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"hot", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder()))), (Object)"_default_tier", (Object)Stream.of(new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withAvailableSegments(this.availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).build();
        DruidCoordinatorRuleRunner runner = new DruidCoordinatorRuleRunner(new ReplicationThrottler(7, 1), this.coordinator);
        DruidCoordinatorRuntimeParams afterParams = runner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)24L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)7L, (long)stats.getTieredStat("assignedCount", "_default_tier"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        exec.shutdown();
    }

    @Test
    public void testDropReplicantThrottle() throws Exception {
        this.mockCoordinator();
        this.mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new IntervalLoadRule(Intervals.of((String)"2012-01-01T00:00:00.000Z/2013-01-02T00:00:00.000Z"), (Map)ImmutableMap.of((Object)"normal", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DataSegment overFlowSegment = new DataSegment("test", Intervals.of((String)"2012-02-01/2012-02-02"), DateTimes.nowUtc().toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(1), 0L);
        ArrayList longerAvailableSegments = Lists.newArrayList(this.availableSegments);
        longerAvailableSegments.add(overFlowSegment);
        DruidServer server1 = new DruidServer("serverNorm1", "hostNorm1", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (Object availableSegment : longerAvailableSegments) {
            server1.addDataSegment((DataSegment)availableSegment);
        }
        DruidServer server2 = new DruidServer("serverNorm2", "hostNorm2", null, 1000L, ServerType.HISTORICAL, "normal", 0);
        for (DataSegment availableSegment : longerAvailableSegments) {
            server2.addDataSegment(availableSegment);
        }
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)Stream.of(new ServerHolder(server1.toImmutableDruidServer(), this.mockPeon), new ServerHolder(server2.toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        SegmentReplicantLookup segmentReplicantLookup = SegmentReplicantLookup.make((DruidCluster)druidCluster);
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMillisToWaitBeforeDeleting(0L).build()).withAvailableSegments((Collection)longerAvailableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(segmentReplicantLookup).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)25L, (long)stats.getTieredStat("droppedCount", "normal"));
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        exec.shutdown();
    }

    @Test
    public void testRulesRunOnNonOvershadowedSegmentsOnly() throws Exception {
        HashSet<DataSegment> availableSegments = new HashSet<DataSegment>();
        DataSegment v1 = new DataSegment("test", Intervals.of((String)"2012-01-01/2012-01-02"), "1", (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        DataSegment v2 = new DataSegment("test", Intervals.of((String)"2012-01-01/2012-01-02"), "2", (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        availableSegments.add(v1);
        availableSegments.add(v2);
        this.mockCoordinator();
        this.mockPeon.loadSegment((DataSegment)EasyMock.eq((Object)v2), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        this.mockEmptyPeon();
        EasyMock.expect((Object)this.databaseRuleManager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn((Object)Lists.newArrayList((Object[])new Rule[]{new ForeverLoadRule((Map)ImmutableMap.of((Object)"_default_tier", (Object)1))})).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.databaseRuleManager});
        DruidCluster druidCluster = new DruidCluster(null, (Map)ImmutableMap.of((Object)"_default_tier", (Object)Stream.of(new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), this.mockPeon)).collect(Collectors.toCollection(() -> new TreeSet(Collections.reverseOrder())))));
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        CostBalancerStrategy balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(exec);
        DruidCoordinatorRuntimeParams params = new DruidCoordinatorRuntimeParams.Builder().withDruidCluster(druidCluster).withAvailableSegments(availableSegments).withDatabaseRuleManager(this.databaseRuleManager).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster())).withBalancerStrategy((BalancerStrategy)balancerStrategy).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMaxSegmentsToMove(5).build()).build();
        DruidCoordinatorRuntimeParams afterParams = this.ruleRunner.run(params);
        CoordinatorStats stats = afterParams.getCoordinatorStats();
        Assert.assertEquals((long)1L, (long)stats.getTiers("assignedCount").size());
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "_default_tier"));
        Assert.assertTrue((boolean)stats.getTiers("unassignedCount").isEmpty());
        Assert.assertTrue((boolean)stats.getTiers("unassignedSize").isEmpty());
        Assert.assertEquals((long)2L, (long)availableSegments.size());
        Assert.assertEquals(availableSegments, (Object)params.getAvailableSegments());
        Assert.assertEquals(availableSegments, (Object)afterParams.getAvailableSegments());
        EasyMock.verify((Object[])new Object[]{this.mockPeon});
        exec.shutdown();
    }

    private void mockCoordinator() {
        EasyMock.expect((Object)this.coordinator.getDynamicConfigs()).andReturn((Object)this.createCoordinatorDynamicConfig()).anyTimes();
        this.coordinator.removeSegment((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinator});
    }

    private void mockEmptyPeon() {
        EasyMock.expect((Object)this.mockPeon.getSegmentsToLoad()).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)this.mockPeon.getSegmentsMarkedToDrop()).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)this.mockPeon.getLoadQueueSize()).andReturn((Object)0L).atLeastOnce();
        EasyMock.expect((Object)this.mockPeon.getNumberOfSegmentsInQueue()).andReturn((Object)0).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockPeon});
    }

    private CoordinatorDynamicConfig createCoordinatorDynamicConfig() {
        return CoordinatorDynamicConfig.builder().withMillisToWaitBeforeDeleting(0L).withMergeBytesLimit(0L).withMergeSegmentsLimit(0).withMaxSegmentsToMove(0).withReplicantLifetime(1).withReplicationThrottleLimit(24).withBalancerComputeThreads(0).withEmitBalancingStats(false).withKillDataSourceWhitelist(null).withKillAllDataSources(false).withMaxSegmentsInNodeLoadingQueue(1000).build();
    }
}

